/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.num.random;

import jhplot.math.num.random.AbstractDiscreteRandomVariable;
import jhplot.math.num.random.RNG;
import jhplot.math.num.random.RandomRNG;

public class GeometricRandomVariable
extends AbstractDiscreteRandomVariable {
    private double probabilityOfSuccess;

    public GeometricRandomVariable() {
        this(0.5);
    }

    public GeometricRandomVariable(double p) {
        this(p, new RandomRNG());
    }

    public GeometricRandomVariable(double p, RNG source) {
        super(source);
        this.setProbabilityOfSuccess(p);
    }

    public static int nextRandomVariable(double p, RNG source) {
        double u;
        while ((u = source.nextRandomNumber()) <= 0.0) {
        }
        return (int)Math.ceil(Math.log(1.0 - p) * Math.log(u));
    }

    private double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    @Override
    public int nextRandomVariable() {
        return GeometricRandomVariable.nextRandomVariable(this.getProbabilityOfSuccess(), this.getSource());
    }

    private void setProbabilityOfSuccess(double p) {
        if (Double.isNaN(p) || p <= 0.0 || p >= 1.0) {
            throw new IllegalArgumentException("probability of success mustbe between 0.0 and 1.0, exclusive.");
        }
        this.probabilityOfSuccess = p;
    }
}

