/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.num.random;

import jhplot.math.num.random.AbstractContinuousRandomVariable;
import jhplot.math.num.random.GammaRandomVariable;
import jhplot.math.num.random.RNG;
import jhplot.math.num.random.RandomRNG;

public class BetaRandomVariable
extends AbstractContinuousRandomVariable {
    private double alpha;
    private double beta;

    public BetaRandomVariable() {
        this(1.0, 1.0);
    }

    public BetaRandomVariable(double a, double b) {
        this(a, b, new RandomRNG());
    }

    public BetaRandomVariable(double a, double b, RNG source) {
        super(source);
        this.setAlpha(a);
        this.setBeta(b);
    }

    public static double nextRandomVariable(double a, double b, RNG source) {
        double x = GammaRandomVariable.nextRandomVariable(a, 1.0, source);
        double y = GammaRandomVariable.nextRandomVariable(b, 1.0, source);
        return x / (x + y);
    }

    private double getAlpha() {
        return this.alpha;
    }

    private double getBeta() {
        return this.beta;
    }

    @Override
    public double nextRandomVariable() {
        return BetaRandomVariable.nextRandomVariable(this.getAlpha(), this.getBeta(), this.getSource());
    }

    private void setAlpha(double a) {
        if (a <= 0.0 || Double.isNaN(a)) {
            throw new IllegalArgumentException("Alpha must be positive.");
        }
        this.alpha = a;
    }

    private void setBeta(double b) {
        if (b <= 0.0 || Double.isNaN(b)) {
            throw new IllegalArgumentException("Beta must be positive.");
        }
        this.beta = b;
    }
}

