/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.num.pdf;

import jhplot.math.num.pdf.ContinuousDistribution;

public class Rayleigh
extends ContinuousDistribution {
    private double scale;

    public Rayleigh() {
        this(1.0);
    }

    public Rayleigh(double s) {
        this.setScale(s);
    }

    @Override
    public double cumulativeProbability(double x) {
        double ret;
        if (Double.isNaN(x)) {
            ret = Double.NaN;
        } else if (x <= 0.0) {
            ret = 0.0;
        } else if (Double.isInfinite(x)) {
            ret = 1.0;
        } else {
            double r = x / this.scale;
            ret = 1.0 - Math.exp(-r * r / 2.0);
        }
        return ret;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        double ret;
        if (p < 0.0 || p > 1.0 || Double.isNaN(p)) {
            ret = Double.NaN;
        } else if (p == 0.0) {
            ret = 0.0;
        } else if (p == 1.0) {
            ret = Double.POSITIVE_INFINITY;
        } else {
            double q = 1.0 - p;
            ret = this.scale * Math.sqrt(Math.log(1.0 / (q * q)));
        }
        return ret;
    }

    public void setScale(double s) {
        if (s <= 0.0 || Double.isNaN(s)) {
            throw new IllegalArgumentException("scale parameter must be positive.");
        }
        this.scale = s;
    }
}

