/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.num;

public class DoubleArray {
    private double[] array = new double[16];
    private int size = 0;

    private void accomodate(int n) {
        while (this.array.length < n) {
            this.expand();
        }
    }

    public void add(double value) {
        if (this.size >= this.array.length) {
            this.expand();
        }
        this.array[this.size++] = value;
    }

    public void clear() {
        this.size = 0;
    }

    private void expand() {
        double[] temp = new double[this.array.length * 2];
        System.arraycopy(this.array, 0, temp, 0, this.size);
        this.array = temp;
    }

    public double get(int index) {
        double value = Double.NaN;
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException("Invalid index: " + index);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException("Index must be non-negative.");
        }
        value = this.array[index];
        return value;
    }

    public int getSize() {
        return this.size;
    }

    public void set(int index, double value) {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException("Index must be non-negative.");
        }
        this.accomodate(index);
        this.array[index] = value;
        if (index >= this.size) {
            this.setSize(index + 1);
        }
    }

    public void setSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Size must be non-negative.");
        }
        this.accomodate(n);
        this.size = n;
    }

    public double[] toArray() {
        double[] ret = new double[this.size];
        System.arraycopy(this.array, 0, ret, 0, this.size);
        return ret;
    }
}

