/*
 * Decompiled with CFR 0.152.
 */
package jhplot.io;

import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JOptionPane;
import jhplot.HPlot;
import jplot.DataArray;
import jplot.GraphSettings;
import jplot.JPlot;
import jplot.LinePars;
import jplot.XMLRead;

public class JHreader {
    private static String fname;
    private static int IndexData;
    private static Font defFont;
    private static Color defColor;
    private static Color defColorB;

    public static boolean readScript(File f, HPlot hplot) {
        fname = f.getName();
        fname = fname.substring(0, fname.length() - 4);
        String fpath = f.getParent();
        String fpathname = f.getAbsolutePath();
        String script = fname + "/" + fname + ".xml";
        try {
            JarFile zf = new JarFile(f);
            JarEntry entry = zf.getJarEntry(script);
            InputStream in = zf.getInputStream(entry);
            InputStreamReader isr = new InputStreamReader(in);
            BufferedReader reader = new BufferedReader(isr);
            XMLRead xr = new XMLRead();
            if (!xr.parse(reader, "jhplot")) {
                return false;
            }
            hplot.removeGraph();
            if (xr.open("info")) {
                xr.close();
            }
            if (xr.open("globalpanel")) {
                hplot.setSizePanel(xr.getInt("width", 100), xr.getInt("height", 100));
                hplot.setPlotsNum(xr.getInt("numberX", 1), xr.getInt("numberY", 1));
                xr.close();
            }
            if (xr.open("margintop")) {
                hplot.setTextTop(xr.getString("text", " "), xr.getFont("font", defFont), xr.getColor("fcolor", defColor));
                hplot.setMarginSizeTop(xr.getDouble("msize", 0.025));
                hplot.setTextTopColorBack(xr.getColor("bcolor", defColorB));
                hplot.setTextPosTopX(xr.getDouble("mposX", 0.01));
                hplot.setTextPosTopY(xr.getDouble("mposY", 0.01));
                hplot.setTextRotationTop(xr.getInt("mrotation", 0));
                xr.close();
            }
            if (xr.open("marginleft")) {
                hplot.setTextLeft(xr.getString("text", " "), xr.getFont("font", defFont), xr.getColor("fcolor", defColor));
                hplot.setTextLeftColorBack(xr.getColor("bcolor", defColorB));
                hplot.setMarginSizeLeft(xr.getDouble("msize", 0.025));
                hplot.setTextPosLeftX(xr.getDouble("mposX", 0.01));
                hplot.setTextPosLeftY(xr.getDouble("mposY", 0.01));
                hplot.setTextRotationLeft(xr.getInt("mrotation", 0));
                xr.close();
            }
            if (xr.open("marginright")) {
                hplot.setTextRight(xr.getString("text", " "), xr.getFont("font", defFont), xr.getColor("fcolor", defColor));
                hplot.setTextRightColorBack(xr.getColor("bcolor", defColorB));
                hplot.setMarginSizeRight(xr.getDouble("msize", 0.025));
                hplot.setTextPosRightX(xr.getDouble("mposX", 0.01));
                hplot.setTextPosRightY(xr.getDouble("mposY", 0.01));
                hplot.setTextRotationRight(xr.getInt("mrotation", 0));
                xr.close();
            }
            if (xr.open("marginbottom")) {
                hplot.setTextBottom(xr.getString("text", " "), xr.getFont("font", defFont), xr.getColor("fcolor", defColor));
                hplot.setTextBottomColorBack(xr.getColor("bcolor", defColorB));
                hplot.setMarginSizeBottom(xr.getDouble("msize", 0.025));
                hplot.setTextPosBottomX(xr.getDouble("mposX", 0.01));
                hplot.setTextPosBottomY(xr.getDouble("mposY", 0.01));
                hplot.setTextRotationBottom(xr.getInt("mrotation", 0));
                xr.close();
            }
            xr.close();
            hplot.setGraph();
            hplot.getCanvasPanel().updateUI();
            Vector<DataArray>[][] dataHplot = hplot.getData();
            for (int i2 = 0; i2 < hplot.getNtotY(); ++i2) {
                for (int i1 = 0; i1 < hplot.getNtotX(); ++i1) {
                    hplot.cd(i1 + 1, i2 + 1);
                    JPlot jpp = hplot.getJPlot();
                    GraphSettings gss = hplot.getGraphSettings();
                    String sGraph = "plot" + Integer.toString(i1) + Integer.toString(i2);
                    xr.open(sGraph);
                    gss.updateSettings(xr);
                    jpp.setGraphSettings(gss);
                    int k = 0;
                    while (xr.open("datafile")) {
                        LinePars lp = new LinePars("name");
                        lp.updateSettings(xr);
                        script = fname + File.separator + xr.getString("name", "");
                        entry = zf.getJarEntry(script);
                        in = zf.getInputStream(entry);
                        isr = new InputStreamReader(in);
                        reader = new BufferedReader(isr);
                        DataArray data = new DataArray(++IndexData, lp);
                        boolean res = data.parse(reader);
                        if (res) {
                            hplot.draw(data, IndexData);
                        } else {
                            System.out.println("Error in reading:" + script);
                        }
                        xr.close();
                        xr.hide("datafile");
                        ++k;
                    }
                    xr.unHide();
                    xr.close();
                }
            }
        }
        catch (IOException e) {
            JHreader.ErrorMessage("Error in reading the file");
        }
        return true;
    }

    private static void ErrorMessage(String a) {
        JOptionPane dialogError = new JOptionPane();
        JOptionPane.showMessageDialog(dialogError, a, "Error", 0);
    }

    static {
        IndexData = 0;
        defFont = new Font("Lucida Sans", 1, 16);
        defColor = Color.BLACK;
        defColorB = Color.WHITE;
    }
}

