/*
 * Decompiled with CFR 0.152.
 */
package jhplot.io;

import hep.aida.IDataPointSet;
import hep.aida.ref.histogram.Cloud1D;
import hep.aida.ref.histogram.Cloud2D;
import hep.aida.ref.histogram.Histogram1D;
import hep.aida.ref.histogram.Histogram2D;
import hep.io.root.interfaces.TGraph;
import hep.io.root.interfaces.TH1;
import hep.io.root.interfaces.TH2;
import japlot.jaxodraw.JaxoMainPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jhplot.DrawOptions;
import jhplot.F1D;
import jhplot.F2D;
import jhplot.FND;
import jhplot.H1D;
import jhplot.H2D;
import jhplot.HKey;
import jhplot.HLabel;
import jhplot.HMLabel;
import jhplot.HPlot;
import jhplot.HPlot3D;
import jhplot.HPlotJa;
import jhplot.HTable;
import jhplot.P0D;
import jhplot.P0I;
import jhplot.P1D;
import jhplot.P2D;
import jhplot.PND;
import jhplot.PNI;
import jhplot.gui.GHFrame;
import jhplot.io.AidaDirectoryTreeCellRenderer;
import jhplot.shapes.HShape;
import jhplot.utils.Util;

public class BrowserDataGeneric
extends JDialog {
    private static final long serialVersionUID = 1L;
    public JButton closeButton;
    private JButton runButton;
    private JButton tableButton;
    private Map<String, Object> map;
    private JCheckBox cb;
    boolean state;
    private GHFrame gframe;
    private JaxoMainPanel jaframe;
    private JTree jtree;
    private HashMap<String, String> tooltips;
    private ArrayList<String[]> data;
    private SortedSet examplekeys;
    private String selected = null;
    private JScrollPane jCandScroll;
    private boolean is3D;
    static Random random = new Random();
    private static final ImageIcon h1Icon = new ImageIcon(AidaDirectoryTreeCellRenderer.class.getResource("icons/h1_t.gif"));
    private static final ImageIcon h2Icon = new ImageIcon(AidaDirectoryTreeCellRenderer.class.getResource("icons/h2_t.gif"));
    private static final ImageIcon h3Icon = new ImageIcon(AidaDirectoryTreeCellRenderer.class.getResource("icons/h3_t.gif"));
    private static final ImageIcon icloud1d = new ImageIcon(AidaDirectoryTreeCellRenderer.class.getResource("icons/icloud1d.png"));
    private static final ImageIcon icloud2d = new ImageIcon(AidaDirectoryTreeCellRenderer.class.getResource("icons/icloud2d.png"));
    private static final ImageIcon icloud3d = new ImageIcon(AidaDirectoryTreeCellRenderer.class.getResource("icons/icloud3d.png"));
    private static final ImageIcon idatapointset = new ImageIcon(AidaDirectoryTreeCellRenderer.class.getResource("icons/idatapointset.png"));
    private static final ImageIcon iprofile1d = new ImageIcon(AidaDirectoryTreeCellRenderer.class.getResource("icons/iprofile1d.png"));
    private static final ImageIcon ifunction1d = new ImageIcon(AidaDirectoryTreeCellRenderer.class.getResource("icons/ifunction1d.png"));
    private static final ImageIcon ituplecolumn = new ImageIcon(AidaDirectoryTreeCellRenderer.class.getResource("icons/ituplecolumn.png"));
    private static final ImageIcon folderclosed = new ImageIcon(AidaDirectoryTreeCellRenderer.class.getResource("icons/folderclosed.png"));
    private static final ImageIcon folderopen = new ImageIcon(AidaDirectoryTreeCellRenderer.class.getResource("icons/folderopen.png"));
    ImageIcon all = new ImageIcon(this.getClass().getResource("/images/objects/all.png"));
    ImageIcon imageH1D = new ImageIcon(this.getClass().getResource("/images/objects/h1.png"));
    ImageIcon imageH2D = new ImageIcon(this.getClass().getResource("/images/objects/h2.png"));
    ImageIcon imageF1D = new ImageIcon(this.getClass().getResource("/images/objects/f1.png"));
    ImageIcon imageF2D = new ImageIcon(this.getClass().getResource("/images/objects/f2.png"));
    ImageIcon imageP1D = new ImageIcon(this.getClass().getResource("/images/objects/p1.png"));
    ImageIcon imageP0D = new ImageIcon(this.getClass().getResource("/images/objects/p0.png"));
    ImageIcon imageCloud = new ImageIcon(this.getClass().getResource("/images/Cloud.gif"));
    ImageIcon closedIcon = new ImageIcon(this.getClass().getResource("/images/folderclosed.png"));
    ImageIcon openIcon = new ImageIcon(this.getClass().getResource("/images/folderopen.png"));

    public BrowserDataGeneric() {
        this.cb = new JCheckBox("Overlay");
        this.setTitle("Objects");
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        JPanel lowerPanel = new JPanel();
        this.closeButton = new JButton();
        this.closeButton.setText("Exit");
        this.tableButton = new JButton();
        this.tableButton.setText("Table");
        this.runButton = new JButton();
        this.runButton.setText("Plot");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserDataGeneric.this.showIt(false);
            }
        });
        this.tableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Object obj = BrowserDataGeneric.this.map.get(BrowserDataGeneric.this.selected);
                Class<?> cls = obj.getClass();
                String name = cls.getName();
                if (name.indexOf("P0D") > -1) {
                    new HTable((P0D)obj);
                } else if (name.indexOf("P0I") > -1) {
                    new HTable((P0I)obj);
                } else if (name.indexOf("P1D") > -1) {
                    new HTable((P1D)obj);
                } else if (name.indexOf("H1D") > -1) {
                    new HTable((H1D)obj);
                } else if (name.indexOf("F1D") > -1) {
                    new HTable((F1D)obj);
                } else if (name.indexOf("PND") > -1) {
                    new HTable((PND)obj);
                } else if (name.indexOf("PNI") > -1) {
                    new HTable((PNI)obj);
                } else {
                    String a = "The object \"" + name + "\" cannot be shown as a table";
                    Util.ErrorMessage((String)a);
                }
            }
        });
        lowerPanel.add((Component)this.runButton, null);
        lowerPanel.add((Component)this.cb, null);
        lowerPanel.add((Component)this.tableButton, null);
        lowerPanel.add((Component)this.closeButton, null);
        this.getContentPane().add((Component)lowerPanel, "South");
    }

    public void setDataFileBrowser(final JaxoMainPanel jaframe, final Map<String, Object> map, boolean ishow) {
        this.jaframe = jaframe;
        this.map = map;
        this.fillJTree();
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Object obj = map.get(BrowserDataGeneric.this.selected);
                Class<?> cls = obj.getClass();
                String name = cls.getName();
                HPlotJa jp = jaframe.getJaPlot();
                Color randomColor = Color.getHSBColor(random.nextFloat(), 1.0f, 1.0f);
                if (!BrowserDataGeneric.this.cb.isSelected()) {
                    jp.clearAllData();
                }
                jp.setAutoRange();
                if (name.indexOf("TH1F") > -1 || name.indexOf("TH1D") > -1) {
                    H1D h = new H1D((TH1)obj);
                    jp.draw(h);
                } else if (name.indexOf("TGraph") > -1) {
                    TGraph tt = (TGraph)obj;
                    String tname = tt.getTitle();
                    double[] x = tt.getX();
                    double[] y = tt.getY();
                    P1D p = new P1D(tname, x, y);
                    p.setColor(randomColor);
                    jp.draw(p);
                } else if (name.indexOf("P0D") > -1) {
                    P0D a = (P0D)obj;
                    H1D h = a.getH1D(100);
                    jp.draw(h);
                } else if (name.indexOf("P0I") > -1) {
                    P0I a = (P0I)obj;
                    H1D h = a.getH1D(100);
                    h.setColor(randomColor);
                    jp.draw(h);
                } else if (name.indexOf("PND") > -1) {
                    PND a = (PND)obj;
                    H1D h = a.getH1D(100);
                    h.setColor(randomColor);
                    jp.draw(h);
                } else if (name.indexOf("PNI") > -1) {
                    PNI a = (PNI)obj;
                    H1D h = a.getH1D(100);
                    h.setColor(randomColor);
                    jp.draw(h);
                } else if (name.indexOf("P1D") > -1) {
                    P1D a = (P1D)obj;
                    jp.draw(a);
                } else if (name.indexOf("F1D") > -1) {
                    jp.setAutoRange();
                    F1D a = (F1D)obj;
                    a.setColor(randomColor);
                    jp.draw(a);
                } else if (name.indexOf("H1D") > -1) {
                    H1D h1 = (H1D)obj;
                    jp.draw(h1);
                } else if (name.indexOf("FND") > -1) {
                    jp.draw((FND)obj);
                } else if (name.indexOf("FNI") > -1) {
                    jp.draw((FND)obj);
                } else if (name.indexOf("IHistogram1D") > -1) {
                    H1D h1 = new H1D((Histogram1D)obj);
                    h1.setColor(randomColor);
                    jp.draw(h1);
                } else if (name.indexOf("ICloud1D") > -1) {
                    H1D h1 = new H1D((Cloud1D)obj, 100);
                    h1.setColor(randomColor);
                    jp.draw(h1);
                } else if (name.indexOf("IDataPointSet") > -1) {
                    P1D h1 = new P1D((IDataPointSet)obj);
                    h1.setColor(randomColor);
                    jp.draw(h1);
                } else if (name.indexOf("ICloud2D") > -1) {
                    P1D h1 = new P1D((Cloud2D)obj);
                    h1.setColor(randomColor);
                    jp.draw(h1);
                } else {
                    String a = "The object \"" + name + "\" cannot be drawn on HPlot canvas";
                    Util.ErrorMessage((String)a);
                    return;
                }
                jp.update();
            }
        });
        this.showIt(ishow);
    }

    public void setDataFileBrowser(final GHFrame gframe, final Map<String, Object> map, boolean ishow) {
        this.gframe = gframe;
        this.map = map;
        this.fillJTree();
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Object obj = map.get(BrowserDataGeneric.this.selected);
                Class<?> cls = obj.getClass();
                String name = cls.getName();
                Color randomColor = Color.getHSBColor(random.nextFloat(), 1.0f, 1.0f);
                if (gframe instanceof HPlot) {
                    DrawOptions h1;
                    Object a;
                    HPlot frame = (HPlot)gframe;
                    if (!BrowserDataGeneric.this.cb.isSelected()) {
                        frame.clearAll();
                    }
                    frame.setAutoRange();
                    if (name.indexOf("TH1F") > -1 || name.indexOf("TH1D") > -1) {
                        H1D h = new H1D((TH1)obj);
                        frame.draw(h);
                    } else if (name.indexOf("TGraph") > -1) {
                        TGraph tt = (TGraph)obj;
                        String tname = tt.getTitle();
                        double[] x = tt.getX();
                        double[] y = tt.getY();
                        P1D p = new P1D(tname, x, y);
                        frame.draw(p);
                    } else if (name.indexOf("P0D") > -1) {
                        a = (P0D)obj;
                        H1D h = ((P0D)a).getH1D(100);
                        frame.draw(h);
                    } else if (name.indexOf("P0I") > -1) {
                        a = (P0I)obj;
                        H1D h = ((P0I)a).getH1D(100);
                        frame.draw(h);
                    } else if (name.indexOf("PND") > -1) {
                        a = (PND)obj;
                        H1D h = ((PND)a).getH1D(100);
                        frame.draw(h);
                    } else if (name.indexOf("PNI") > -1) {
                        a = (PNI)obj;
                        if (((PNI)a).size() > 0) {
                            H1D h = ((PNI)a).getH1D(100);
                            frame.draw(h);
                        }
                    } else if (name.indexOf("P1D") > -1) {
                        a = (P1D)obj;
                        ((DrawOptions)a).setColor(randomColor);
                        int symbol = (int)(5.0f * random.nextFloat());
                        if (symbol <= 0) {
                            symbol = 1;
                        }
                        ((DrawOptions)a).setSymbol(symbol);
                        ((DrawOptions)a).setSymbolSize(4);
                        ((DrawOptions)a).setStyle("p");
                        ((DrawOptions)a).setPenWidth(3);
                        ((DrawOptions)a).setColor(randomColor);
                        frame.draw((P1D)a);
                    } else if (name.indexOf("F1D") > -1) {
                        a = (F1D)obj;
                        ((F1D)a).parse();
                        ((DrawOptions)a).setColor(randomColor);
                        frame.draw((F1D)a);
                    } else if (name.indexOf("H1D") > -1) {
                        h1 = (H1D)obj;
                        h1.setFill(true);
                        h1.setStyle("h");
                        h1.setPenWidthErr(1);
                        h1.setPenWidth(1);
                        h1.setFillColorTransparency(0.6);
                        h1.setFillColor(randomColor);
                        h1.setColor(Color.black);
                        frame.draw((H1D)h1);
                    } else if (name.indexOf("FND") > -1) {
                        frame.draw((FND)obj);
                    } else if (name.indexOf("FNI") > -1) {
                        frame.draw((FND)obj);
                    } else if (name.indexOf("HLabel") > -1) {
                        frame.draw((HLabel)obj);
                    } else if (name.equalsIgnoreCase("jhplot.HKey")) {
                        frame.draw((HKey)obj);
                    } else if (name.equalsIgnoreCase("jhplot.HShape")) {
                        frame.draw((HShape)obj);
                    } else if (name.equalsIgnoreCase("jhplot.HMLabel")) {
                        frame.draw((HMLabel)obj);
                    } else if (name.equalsIgnoreCase("java.lang.String")) {
                        a = new HLabel((String)obj);
                        frame.draw((HLabel)a);
                    } else if (name.equalsIgnoreCase("javax.swing.JFrame")) {
                        ((JFrame)obj).setVisible(true);
                    } else if (name.indexOf("IHistogram1D") > -1) {
                        h1 = new H1D((Histogram1D)obj);
                        h1.setColor(randomColor);
                        frame.draw((H1D)h1);
                    } else if (name.indexOf("ICloud1D") > -1) {
                        h1 = new H1D((Cloud1D)obj, 100);
                        frame.draw((H1D)h1);
                    } else if (name.indexOf("IDataPointSet") > -1) {
                        h1 = new P1D((IDataPointSet)obj);
                        h1.setColor(randomColor);
                        frame.draw((P1D)h1);
                    } else if (name.indexOf("ICloud2D") > -1) {
                        h1 = new P1D((Cloud2D)obj);
                        h1.setColor(randomColor);
                        frame.draw((P1D)h1);
                    } else {
                        a = "The object \"" + name + "\" cannot be drawn on HPlot canvas";
                        Util.ErrorMessage((String)a);
                    }
                    if (gframe instanceof HPlot3D) {
                        HPlot3D frame3d = (HPlot3D)gframe;
                        frame3d.setAutoRange();
                        if (!BrowserDataGeneric.this.cb.isSelected()) {
                            frame3d.clearAll();
                        }
                        if (name.indexOf("P2D") > -1) {
                            P2D a2 = (P2D)obj;
                            if (a2.size() > 0) {
                                frame3d.draw(a2);
                            }
                        } else if (name.indexOf("F2D") > -1) {
                            F2D a3 = (F2D)obj;
                            frame3d.draw(a3);
                        } else if (name.indexOf("H2D") > -1) {
                            H2D a4 = (H2D)obj;
                            frame3d.draw(a4);
                        } else if (name.indexOf("TH2F") > -1 || name.indexOf("TH2D") > -1) {
                            H2D h = new H2D((TH2)obj);
                            frame3d.draw(h);
                        } else if (name.indexOf("IHistogram2D") > -1) {
                            H2D h12 = new H2D((Histogram2D)obj);
                            frame3d.draw(h12);
                        } else {
                            String a5 = "The object \"" + name + "\" cannot be drawn on HPlot3D canvas";
                            Util.ErrorMessage((String)a5);
                        }
                    }
                }
            }
        });
        this.showIt(ishow);
    }

    public void showIt(boolean show) {
        if (!show) {
            this.setVisible(false);
            this.gframe = null;
        } else {
            GHFrame frame;
            JFrame jf = null;
            if (this.gframe instanceof HPlot3D) {
                frame = (HPlot3D)this.gframe;
                jf = frame.getFrame();
            }
            if (this.gframe instanceof HPlot) {
                frame = (HPlot)this.gframe;
                jf = frame.getFrame();
            }
            if (this.jaframe != null) {
                jf = this.jaframe;
            }
            Dimension dim = jf.getSize();
            int w = dim.width;
            int h = dim.height;
            Dimension res = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension size = new Dimension(Math.min((int)(0.4 * (double)w), res.width), Math.min((int)(1.0 * (double)h), res.height));
            this.setSize(size);
            Util.rightWithin((Component)jf, (Component)this);
            this.setVisible(true);
        }
    }

    private void fillJTree() {
        int n = 0;
        this.data = new ArrayList();
        this.examplekeys = new TreeSet();
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            String[] anArray;
            String key = entry.getKey();
            Object value = entry.getValue();
            String name = value.getClass().getSimpleName();
            String[] words = key.split("/");
            if (words.length > 1) {
                anArray = new String[]{words[0], words[1], name};
                this.examplekeys.add(anArray[0]);
                this.data.add(anArray);
            } else if (words.length < 2) {
                anArray = new String[]{words[0], name};
                this.data.add(anArray);
            }
            ++n;
        }
        this.tooltips = new HashMap();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Root");
        for (String key : this.examplekeys) {
            DefaultMutableTreeNode topic = new DefaultMutableTreeNode(key);
            root.add(topic);
            for (String[] element : this.data) {
                if (!element[0].equals(key)) continue;
                DefaultMutableTreeNode entry = new DefaultMutableTreeNode(element[1]);
                topic.add(entry);
                this.tooltips.put(element[1], element[2]);
            }
        }
        for (String[] element : this.data) {
            if (element.length != 2) continue;
            DefaultMutableTreeNode entry = new DefaultMutableTreeNode(element[0]);
            root.add(entry);
            this.tooltips.put(element[0], element[1]);
        }
        this.jtree = new JTree(root);
        if (ituplecolumn != null) {
            this.jtree.setCellRenderer(new OwnRenderer(ituplecolumn));
            ToolTipManager.sharedInstance().registerComponent(this.jtree);
        }
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.jtree.getCellRenderer();
        renderer.setClosedIcon(folderclosed);
        renderer.setOpenIcon(folderopen);
        renderer.setLeafIcon(ituplecolumn);
        this.jtree.setRootVisible(false);
        this.jtree.getSelectionModel().setSelectionMode(1);
        this.jtree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getPath();
                String sb = "";
                Object[] objects = path.getPath();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
                node.getChildCount();
                for (int j = 1; j < objects.length; ++j) {
                    TreeNode gn = (TreeNode)objects[j];
                    String s = gn.toString();
                    sb = sb + "/" + s;
                }
                if (node.getChildCount() > 0) {
                    BrowserDataGeneric.this.selected = "";
                    return;
                }
                BrowserDataGeneric.this.selected = sb;
                BrowserDataGeneric.this.selected = BrowserDataGeneric.this.selected.substring(1, BrowserDataGeneric.this.selected.length());
            }
        });
        this.jCandScroll = new JScrollPane();
        this.jCandScroll.setPreferredSize(new Dimension(1, 1));
        this.jCandScroll.setMinimumSize(new Dimension(0, 0));
        this.getContentPane().add((Component)this.jCandScroll, "Center");
        this.jCandScroll.getViewport().add(this.jtree);
    }

    private class OwnRenderer
    extends DefaultTreeCellRenderer {
        Icon tutorialIcon;

        public OwnRenderer(Icon icon) {
            this.tutorialIcon = icon;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (leaf) {
                String svalue = value.toString();
                String name = (String)BrowserDataGeneric.this.tooltips.get(svalue);
                ImageIcon img = BrowserDataGeneric.this.all;
                if (name.indexOf("H1D") > -1 || name.indexOf("TH1F") > -1 || name.indexOf("TH1D") > -1) {
                    img = BrowserDataGeneric.this.imageH1D;
                }
                if (name.indexOf("H2D") > -1) {
                    img = BrowserDataGeneric.this.imageH2D;
                }
                if (name.indexOf("H3D") > -1) {
                    img = BrowserDataGeneric.this.imageH2D;
                }
                if (name.indexOf("F1D") > -1) {
                    img = BrowserDataGeneric.this.imageF1D;
                }
                if (name.indexOf("F2D") > -1) {
                    img = BrowserDataGeneric.this.imageF2D;
                }
                if (name.indexOf("Cloud") > -1 || name.indexOf("TGraph") > -1) {
                    img = BrowserDataGeneric.this.imageCloud;
                }
                if (name.indexOf("Histogram1D") > -1) {
                    img = h1Icon;
                }
                if (name.indexOf("Histogram2D") > -1 || name.indexOf("TH2F") > -1 || name.indexOf("TH2D") > -1) {
                    img = h2Icon;
                }
                if (name.indexOf("P0") > -1) {
                    img = BrowserDataGeneric.this.imageP0D;
                }
                if (name.indexOf("P1D") > -1) {
                    img = BrowserDataGeneric.this.imageP1D;
                }
                if (name.indexOf("P2D") > -1) {
                    img = BrowserDataGeneric.this.imageP0D;
                }
                if (name.indexOf("PN") > -1) {
                    img = BrowserDataGeneric.this.imageP0D;
                }
                if (name.indexOf("HProf") > -1) {
                    img = iprofile1d;
                }
                if (name.indexOf("ICloud1") > -1) {
                    img = icloud1d;
                }
                if (name.indexOf("ICloud2") > -1) {
                    img = icloud2d;
                }
                this.setIcon(img);
                if (BrowserDataGeneric.this.tooltips.isEmpty()) {
                    this.setToolTipText(null);
                }
                this.setToolTipText(name);
            } else {
                this.setToolTipText(null);
            }
            return this;
        }
    }
}

