/*
 * Decompiled with CFR 0.152.
 */
package jhplot.bsom;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jhplot.bsom.AlphaSlider;
import jhplot.bsom.BetaSlider;
import jhplot.bsom.DrawArea;
import jhplot.bsom.HeightSlider;
import jhplot.bsom.NoiseSlider;
import jhplot.bsom.PhaseSlider;
import jhplot.bsom.WidthSlider;

public class BsomDemo
extends JFrame {
    private static final long serialVersionUID = 1L;
    protected DrawArea drawArea;
    protected AlphaSlider alphaSlider;
    protected BetaSlider betaSlider;
    protected WidthSlider widthSlider;
    protected HeightSlider heightSlider;
    protected PhaseSlider phaseSlider;
    protected NoiseSlider noiseSlider;
    protected JButton initButton;
    protected JCheckBox learnButton;
    protected JCheckBox autoButton;
    protected JCheckBox densityButton;
    protected JTextField unitNumberText;
    protected int xd;
    protected int yd;
    protected double scale;
    protected int n_data;
    protected int n_unit;
    protected int dstep;
    public static double delta = 1.0E-6;
    double width_range = 2.0;
    double height_range = 2.0;
    double phase_range = 0.5;
    double noise_range = 0.5;
    double initial_width = 2.0;
    double initial_height = 1.0;
    double initial_noise_level = 0.2;
    double initial_phase = 0.0;
    double initial_weight_level = 0.1;
    protected double alpha_min_power;
    protected double alpha_max_power;
    protected double beta_min_power;
    protected double beta_max_power;
    protected double initial_alpha;
    protected double initial_beta;

    public void init() {
        this.n_data = 100;
        this.n_unit = 20;
        this.alpha_min_power = 0.0;
        this.alpha_max_power = 5.0;
        this.beta_min_power = 0.0;
        this.beta_max_power = 5.0;
        this.initial_alpha = Math.pow(10.0, this.alpha_max_power);
        this.initial_beta = Math.pow(10.0, this.beta_min_power);
        this.xd = 210;
        this.yd = 150;
        this.scale = 70.0;
        this.dstep = 10;
        this.initial_weight_level = 0.1;
        this.setLayout(new BorderLayout());
        this.drawArea = new DrawArea(this, this.xd, this.yd, this.scale);
        this.drawArea.setBackground(Color.white);
        this.drawArea.setSize(new Dimension(600, 400));
        this.drawArea.n_data = this.n_data;
        this.drawArea.n_unit = this.n_unit;
        this.drawArea.dstep = this.dstep;
        this.drawArea.width = this.initial_width;
        this.drawArea.height = this.initial_height;
        this.drawArea.noise_level = this.initial_noise_level;
        this.drawArea.phase = this.initial_phase;
        this.drawArea.initial_weight_level = this.initial_weight_level;
        this.drawArea.alpha = this.initial_alpha;
        this.drawArea.beta = this.initial_beta;
        this.add("Center", this.drawArea);
        JPanel controlPanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(5, 1));
        this.learnButton = new JCheckBox("learn");
        this.learnButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                BsomDemo.this.drawArea.learn = BsomDemo.this.learnButton.isSelected();
                if (!BsomDemo.this.drawArea.learn && BsomDemo.this.drawArea.auto_learn) {
                    BsomDemo.this.drawArea.auto_learn = false;
                    BsomDemo.this.autoButton.setSelected(false);
                }
            }
        });
        this.autoButton = new JCheckBox("auto");
        this.autoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                BsomDemo.this.drawArea.auto_learn = BsomDemo.this.autoButton.isSelected();
                if (!BsomDemo.this.drawArea.learn && BsomDemo.this.drawArea.auto_learn) {
                    BsomDemo.this.drawArea.learn = true;
                    BsomDemo.this.learnButton.setSelected(true);
                }
            }
        });
        this.densityButton = new JCheckBox("density");
        this.densityButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (BsomDemo.this.densityButton.isSelected()) {
                    BsomDemo.this.drawArea.stop();
                    BsomDemo.this.drawArea.density_mode = true;
                    BsomDemo.this.drawArea.repaint();
                } else {
                    BsomDemo.this.drawArea.density_mode = false;
                    BsomDemo.this.drawArea.start();
                }
            }
        });
        this.initButton = new JButton("init");
        this.initButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                BsomDemo.this.n_unit = Integer.parseInt(BsomDemo.this.unitNumberText.getText());
                BsomDemo.this.resetUnitNumber(BsomDemo.this.n_unit);
                BsomDemo.this.drawArea.W.init();
                if (BsomDemo.this.drawArea.auto_learn) {
                    BsomDemo.this.alphaSlider.setValueOfSlider(BsomDemo.this.initial_alpha);
                    BsomDemo.this.betaSlider.setValueOfSlider(BsomDemo.this.initial_beta);
                    BsomDemo.this.drawArea.alpha = BsomDemo.this.initial_alpha;
                    BsomDemo.this.drawArea.beta = BsomDemo.this.initial_beta;
                }
            }
        });
        JPanel unitNumberPanel = new JPanel();
        unitNumberPanel.setLayout(new GridLayout(1, 2));
        this.unitNumberText = new JTextField(Integer.toString(this.n_unit), 2);
        this.unitNumberText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BsomDemo.this.n_unit = Integer.parseInt(BsomDemo.this.unitNumberText.getText());
                BsomDemo.this.resetUnitNumber(BsomDemo.this.n_unit);
            }
        });
        JLabel unitNumberLabel = new JLabel("#unit");
        unitNumberPanel.add(unitNumberLabel);
        unitNumberPanel.add(this.unitNumberText);
        buttonPanel.add(this.learnButton);
        buttonPanel.add(this.autoButton);
        buttonPanel.add(this.densityButton);
        buttonPanel.add(this.initButton);
        buttonPanel.add(unitNumberPanel);
        controlPanel.add(buttonPanel);
        Panel weightPanel = new Panel();
        weightPanel.setLayout(new GridLayout(2, 1));
        JPanel alphaSliderPanel = new JPanel();
        alphaSliderPanel.setLayout(new BorderLayout());
        this.alphaSlider = new AlphaSlider(this.drawArea, this.alpha_min_power, this.alpha_max_power);
        Label alabel = new Label("alpha");
        alphaSliderPanel.add("Center", this.alphaSlider);
        alphaSliderPanel.add("South", alabel);
        weightPanel.add(alphaSliderPanel);
        JPanel betaSliderPanel = new JPanel();
        betaSliderPanel.setLayout(new BorderLayout());
        this.betaSlider = new BetaSlider(this.drawArea, this.beta_min_power, this.beta_max_power);
        Label blabel = new Label("beta");
        betaSliderPanel.add("Center", this.betaSlider);
        betaSliderPanel.add("South", blabel);
        weightPanel.add(betaSliderPanel);
        controlPanel.add(weightPanel);
        JPanel dataPanel1 = new JPanel();
        dataPanel1.setLayout(new GridLayout(2, 1));
        JPanel widthSliderPanel = new JPanel();
        widthSliderPanel.setLayout(new BorderLayout());
        this.widthSlider = new WidthSlider(this.drawArea, this.width_range);
        JLabel wlabel = new JLabel("width");
        widthSliderPanel.add("Center", this.widthSlider);
        widthSliderPanel.add("South", wlabel);
        JPanel heightSliderPanel = new JPanel();
        heightSliderPanel.setLayout(new BorderLayout());
        this.heightSlider = new HeightSlider(this.drawArea, this.height_range);
        Label hlabel = new Label("height");
        heightSliderPanel.add("Center", this.heightSlider);
        heightSliderPanel.add("South", hlabel);
        dataPanel1.add(widthSliderPanel);
        dataPanel1.add(heightSliderPanel);
        JPanel dataPanel2 = new JPanel();
        dataPanel2.setLayout(new GridLayout(2, 1));
        JPanel phaseSliderPanel = new JPanel();
        phaseSliderPanel.setLayout(new BorderLayout());
        this.phaseSlider = new PhaseSlider(this.drawArea, this.phase_range);
        Label label5 = new Label("phase");
        phaseSliderPanel.add("Center", this.phaseSlider);
        phaseSliderPanel.add("South", label5);
        JPanel noiseSliderPanel = new JPanel();
        noiseSliderPanel.setLayout(new BorderLayout());
        this.noiseSlider = new NoiseSlider(this.drawArea, this.noise_range);
        Label label6 = new Label("noise level");
        noiseSliderPanel.add("Center", this.noiseSlider);
        noiseSliderPanel.add("South", label6);
        dataPanel2.add(phaseSliderPanel);
        dataPanel2.add(noiseSliderPanel);
        controlPanel.add(dataPanel1);
        controlPanel.add(dataPanel2);
        this.add("South", controlPanel);
        this.alphaSlider.setValueOfSlider(this.initial_alpha);
        this.betaSlider.setValueOfSlider(this.initial_beta);
        this.widthSlider.setValueOfSlider(this.initial_width);
        this.heightSlider.setValueOfSlider(this.initial_height);
        this.phaseSlider.setValueOfSlider(this.initial_phase);
        this.noiseSlider.setValueOfSlider(this.initial_noise_level);
        this.drawArea.init();
        this.repaint();
    }

    public void start() {
        if (!this.drawArea.density_mode) {
            this.drawArea.start();
        }
    }

    public void startNoThread() {
        this.drawArea.runNoThread();
    }

    public void stop() {
        this.drawArea.stop();
    }

    public void learn() {
        this.drawArea.learn = true;
        this.drawArea.auto_learn = false;
    }

    public void auto() {
        this.drawArea.auto_learn = true;
        this.drawArea.learn = true;
    }

    @Override
    public synchronized boolean action(Event evt, Object what) {
        if (evt.target == this.learnButton) {
            this.drawArea.learn = this.learnButton.isSelected();
            if (!this.drawArea.learn && this.drawArea.auto_learn) {
                this.drawArea.auto_learn = false;
                this.autoButton.setSelected(false);
            }
            return true;
        }
        if (evt.target == this.autoButton) {
            this.drawArea.auto_learn = this.autoButton.isSelected();
            if (!this.drawArea.learn && this.drawArea.auto_learn) {
                this.drawArea.learn = true;
                this.learnButton.setSelected(true);
            }
            return true;
        }
        if (evt.target == this.initButton) {
            this.drawArea.W.init();
            if (this.drawArea.auto_learn) {
                this.alphaSlider.setValueOfSlider(this.initial_alpha);
                this.betaSlider.setValueOfSlider(this.initial_beta);
                this.drawArea.alpha = this.initial_alpha;
                this.drawArea.beta = this.initial_beta;
            }
            return true;
        }
        if (evt.target == this.densityButton) {
            if (this.densityButton.isSelected()) {
                this.drawArea.stop();
                this.drawArea.density_mode = true;
                this.drawArea.repaint();
            } else {
                this.drawArea.density_mode = false;
                this.drawArea.start();
            }
            return true;
        }
        if (evt.target == this.unitNumberText) {
            this.resetUnitNumber(Integer.valueOf((String)what));
            return true;
        }
        return false;
    }

    public void setAlphaBeta(double alpha, double beta) {
        this.drawArea.alpha = alpha;
        this.drawArea.beta = beta;
    }

    public void resetUnitNumber(int r) {
        int rmax = 99;
        if (r > rmax) {
            this.showStatus("Too many units.");
            return;
        }
        if (r < 2) {
            this.showStatus("Too few units.");
            return;
        }
        this.drawArea.alpha = this.initial_alpha;
        this.drawArea.beta = this.initial_beta;
        this.drawArea.auto_learn = false;
        this.drawArea.learn = false;
        this.drawArea.n_unit = r;
        this.drawArea.initWeight();
        this.autoButton.setSelected(false);
        this.learnButton.setSelected(false);
        this.alphaSlider.setValueOfSlider(this.initial_alpha);
        this.betaSlider.setValueOfSlider(this.initial_beta);
        this.repaint();
    }

    private void showStatus(String a) {
        JOptionPane dialogError = new JOptionPane();
        JOptionPane.showMessageDialog(dialogError, a, "Error", 0);
    }
}

