/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import hep.aida.IAxis;
import hep.aida.ref.histogram.Histogram1D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import java.util.Vector;
import javax.swing.JOptionPane;
import jhplot.H1D;
import jhplot.P1D;
import jhplot.gui.HelpBrowser;
import ptolemy.plot.EditablePlot;
import ptolemy.plot.plotml.EditablePlotMLApplication;

public class SPlot {
    private EditablePlotMLApplication eplot;
    private EditablePlot pplot;
    private int width = 600;
    private int height = 400;
    private int plot_index = 0;
    private boolean isSetRange = false;

    public SPlot() {
        this.width = 600;
        this.height = 400;
        this.buildGUI();
    }

    public SPlot(File f) {
        this.width = 600;
        this.height = 400;
        this.buildGUI();
        this.read(f);
    }

    public SPlot(int width, int height) {
        this.width = width;
        this.height = height;
        this.buildGUI();
    }

    public SPlot(String title, int width, int height) {
        this.width = width;
        this.height = height;
        this.buildGUI();
        this.pplot.setTitle(title);
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.eplot.setSize(width, height);
    }

    public void setEditable(int index) {
        this.pplot.setEditable(index);
    }

    public double[][] getData(int index) {
        return this.pplot.getData(index);
    }

    public void setBackground(Color c) {
        this.pplot.setBackground(c);
    }

    public void setGTitle(String title) {
        this.pplot.setTitle(title);
    }

    public void setTitle(String title) {
        this.pplot.setTitle(title);
    }

    public void setRange(double xmin, double xmax, double ymin, double ymax) {
        this.pplot.setXRange(xmin, xmax);
        this.pplot.setYRange(ymin, ymax);
        this.isSetRange = true;
    }

    public void addLegend(int dataset, String legend) {
        this.pplot.addLegend(dataset, legend);
    }

    public synchronized void addXTick(String label, double position) {
        this.pplot.addXTick(label, position);
    }

    public synchronized void addYTick(String label, double position) {
        this.pplot.addYTick(label, position);
    }

    public synchronized void clear() {
        this.pplot.clear(true);
        this.update();
    }

    public synchronized void clearLegends() {
        this.pplot.clearLegends();
        this.update();
    }

    public Color[] getColors() {
        return this.pplot.getColors();
    }

    public boolean getGrid() {
        return this.pplot.getGrid();
    }

    public String getLegend(int dataset) {
        return this.pplot.getLegend(dataset);
    }

    public int getLegendDataset(String legend) {
        return this.pplot.getLegendDataset(legend);
    }

    public Rectangle getPlotRectangle() {
        return this.pplot.getPlotRectangle();
    }

    public String getTitle() {
        return this.pplot.getTitle();
    }

    public double[] getXAutoRange() {
        return this.pplot.getXAutoRange();
    }

    public void setColor(boolean useColor) {
        this.pplot.setColor(useColor);
    }

    public void setColors(Color[] colors) {
        this.pplot.setColors(colors);
    }

    public void setForeground(Color foreground) {
        this.pplot.setForeground(foreground);
    }

    public void setGrid(boolean grid) {
        this.pplot.setGrid(grid);
    }

    public void setLabelFont(String name) {
        this.pplot.setLabelFont(name);
    }

    public String getXLabel() {
        return this.pplot.getXLabel();
    }

    public boolean getXLog() {
        return this.pplot.getXLog();
    }

    public double[] getXRange() {
        return this.pplot.getXRange();
    }

    public synchronized Vector[] getXTicks() {
        return this.pplot.getXTicks();
    }

    public double[] getYAutoRange() {
        return this.pplot.getYAutoRange();
    }

    public String getYLabel() {
        return this.pplot.getYLabel();
    }

    public boolean getYLog() {
        return this.pplot.getYLog();
    }

    public double[] getYRange() {
        return this.pplot.getYRange();
    }

    public Vector[] getYTicks() {
        return this.pplot.getYTicks();
    }

    public void renameLegend(int dataset, String newName) {
        this.pplot.renameLegend(dataset, newName);
    }

    public void resetAxes() {
        this.pplot.resetAxes();
    }

    public void setBounds(int x, int y, int width, int height) {
        this.pplot.setBounds(x, y, width, height);
    }

    public void setTitleFont(String name) {
        this.pplot.setTitleFont(name);
    }

    public void setWrap(boolean wrap) {
        this.pplot.setWrap(wrap);
    }

    public void setNameX(String label) {
        this.pplot.setXLabel(label);
    }

    public void setXLog(boolean xlog) {
        this.pplot.setXLog(xlog);
    }

    public void setXRange(double min, double max) {
        this.pplot.setXRange(min, max);
    }

    public void setNameY(String label) {
        this.pplot.setYLabel(label);
    }

    public void setYLog(boolean ylog) {
        this.pplot.setYLog(ylog);
    }

    public void setYRange(double min, double max) {
        this.pplot.setYRange(min, max);
    }

    public void zoom(double lowx, double lowy, double highx, double highy) {
        this.pplot.zoom(lowx, lowy, highx, highy);
    }

    public void write(String file) {
        try {
            FileOutputStream fout = new FileOutputStream(file);
            this.pplot.write((OutputStream)fout);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog((Component)this.pplot, "Error writing file:\n" + ex.toString(), "Ptolemy Plot Error", 2);
        }
    }

    public void read(String file) {
        try {
            this.pplot.clear(true);
            this.pplot.read((InputStream)new FileInputStream(file));
            this.pplot.repaint();
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog((Component)this.pplot, "File not found:\n" + ex.toString(), "Ptolemy Plot Error", 2);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog((Component)this.pplot, "Error reading input:\n" + ex.toString(), "Ptolemy Plot Error", 2);
        }
    }

    public void read(File file) {
        try {
            System.out.println("reading file ..");
            this.pplot.clear(true);
            this.pplot.read((InputStream)new FileInputStream(file));
            this.pplot.repaint();
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog((Component)this.pplot, "File not found:\n" + ex.toString(), "Ptolemy Plot Error", 2);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog((Component)this.pplot, "Error reading input:\n" + ex.toString(), "Ptolemy Plot Error", 2);
        }
    }

    public void draw(double[][] x, double[][] y) {
        this.pplot.setMarksStyle("various");
        this.pplot.setConnected(false, this.plot_index);
        for (int n = 0; n < x[0].length; ++n) {
            for (int i = 0; i < x.length; ++i) {
                this.pplot.addPoint(n, x[i][n], y[i][n], true);
            }
            ++this.plot_index;
        }
        this.update();
    }

    public void draw(double[] x, double[] y) {
        this.pplot.setMarksStyle("various");
        this.pplot.setConnected(false, this.plot_index);
        for (int i = 0; i < x.length; ++i) {
            this.pplot.addPoint(this.plot_index, x[i], y[i], true);
        }
        ++this.plot_index;
        this.update();
    }

    public void draw(String legend, double[] x, double[] y) {
        this.pplot.setMarksStyle("various");
        this.pplot.setConnected(false, this.plot_index);
        this.pplot.addLegend(this.plot_index, legend);
        for (int i = 0; i < x.length; ++i) {
            this.pplot.addPoint(this.plot_index, x[i], y[i], true);
        }
        ++this.plot_index;
        this.update();
    }

    public void draw(String legend, double[] x, double[] y, double[] ey) {
        this.pplot.setMarksStyle("various");
        this.pplot.setConnected(false, this.plot_index);
        this.pplot.addLegend(this.plot_index, legend);
        for (int i = 0; i < x.length; ++i) {
            this.pplot.addPointWithErrorBars(this.plot_index, x[i], y[i], ey[i], ey[i], true);
        }
        ++this.plot_index;
        this.update();
    }

    public void clear(int dataset) {
        if (dataset < this.plot_index) {
            this.pplot.clear(dataset);
        }
        this.update();
    }

    public void erasePoint(int dataset, int index) {
        this.pplot.erasePoint(dataset, index);
    }

    public void fillPlot() {
        this.pplot.fillPlot();
    }

    public void setAutoRange() {
        this.isSetRange = false;
    }

    public void setAutoRange(boolean auto) {
        if (auto) {
            this.isSetRange = false;
        }
        if (!auto) {
            this.isSetRange = true;
        }
    }

    public void update() {
        if (!this.isSetRange) {
            this.pplot.fillPlot();
        } else {
            this.pplot.repaint();
            this.pplot.updateUI();
        }
    }

    public int getNumDataSets() {
        return this.pplot.getNumDataSets();
    }

    public void setBars(boolean on) {
        this.pplot.setBars(on);
    }

    public void setBars(double width, double offset) {
        this.pplot.setBars(width, offset);
    }

    public void setConnected(boolean on, int dataset) {
        this.pplot.setConnected(on, dataset);
    }

    public void addPoint(int dataset, double x, double y, boolean connected) {
        this.pplot.addPoint(dataset, x, y, connected);
    }

    public void addPointErr(int dataset, double x, double y, double yLowEB, double yHighEB, boolean connected) {
        this.pplot.addPointWithErrorBars(dataset, x, y, yLowEB, yHighEB, connected);
    }

    public void setImpulses(boolean on, int dataset) {
        this.pplot.setImpulses(on, dataset);
    }

    public void setMarksStyle(String style) {
        this.pplot.setMarksStyle(style);
    }

    public void setMarksStyle(String style, int dataset) {
        this.pplot.setMarksStyle(style, dataset);
    }

    public void draw(H1D h1) {
        this.pplot.setBars(true);
        this.pplot.setMarksStyle("none");
        this.pplot.setConnected(false, this.plot_index);
        Histogram1D h = h1.get();
        IAxis ax = h.axis();
        double min = ax.lowerEdge();
        double max = ax.upperEdge();
        int bins = ax.bins();
        double width = (max - min) / (double)bins;
        for (int i = 0; i < bins; ++i) {
            double dd = ax.binCenter(i);
            double hh = h1.binHeight(i);
            this.pplot.addPoint(this.plot_index, dd, hh, true);
        }
        ++this.plot_index;
        this.update();
    }

    public void draw(P1D p1d) {
        this.setColor(true);
        Color[] _colors = new Color[]{p1d.getColor(), new Color(255), new Color(43690), new Color(0), new Color(16753920), new Color(5473931), new Color(16744272), new Color(4565791), new Color(9454125), new Color(0xA0A0A0), new Color(0x14FF14)};
        this.setColors(_colors);
        if (p1d.getSymbol() == 11) {
            this.setMarksStyle("pixels");
        } else {
            this.pplot.setMarksStyle("various");
        }
        this.pplot.setConnected(false, this.plot_index);
        for (int i = 0; i < p1d.size(); ++i) {
            if (p1d.dimension() > 2) {
                this.pplot.addPointWithErrorBars(this.plot_index, p1d.getX(i), p1d.getY(i), p1d.getYlower(i), p1d.getYupper(i), true);
                continue;
            }
            this.pplot.addPoint(this.plot_index, p1d.getX(i), p1d.getY(i), true);
        }
        ++this.plot_index;
        this.update();
    }

    public void draw(String[] legend, double[][] x, double[][] y) {
        this.pplot.setMarksStyle("various");
        this.pplot.setConnected(false, this.plot_index);
        for (int n = 0; n < x[0].length; ++n) {
            this.pplot.addLegend(n, legend[n]);
            for (int i = 0; i < x.length; ++i) {
                this.pplot.addPoint(n, x[i][n], y[i][n], true);
            }
            ++this.plot_index;
        }
        this.update();
    }

    public void visible(boolean showIt) {
        this.eplot.showIt(showIt);
    }

    public void visible() {
        this.eplot.showIt(true);
    }

    public void visible(int posX, int posY) {
        this.eplot.setLocation(posX, posY);
        this.eplot.setVisible(true);
    }

    private void buildGUI() {
        this.plot_index = 0;
        String[] tt = new String[]{};
        try {
            this.pplot = new EditablePlot();
            this.pplot.setLabelFont("SansSerif-BOLD-14");
            this.eplot = new EditablePlotMLApplication(this.pplot, tt);
            this.eplot.setSize(this.width, this.height);
            this.pplot.setConnected(false);
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
            ex.printStackTrace();
        }
        this.pplot.setBackground(Color.white);
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            System.out.println("reading file=" + args[0]);
            SPlot sp = new SPlot(new File(args[0]));
            sp.visible();
            sp.update();
        } else {
            SPlot sp = new SPlot("Test", 600, 400);
            sp.visible();
            Random rand = new Random();
            double[] x = new double[500];
            double[] y = new double[500];
            for (int i = 0; i < 500; ++i) {
                x[i] = rand.nextGaussian();
                y[i] = rand.nextGaussian();
            }
            sp.draw(x, y);
            sp.update();
        }
    }

    public void export(String f) {
        this.pplot.export(f);
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

