/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jhplot.HTable;
import jhplot.Plottable;
import jhplot.gui.HelpBrowser;
import jhplot.io.Serialized;
import jhplot.utils.Util;
import jplot.DataArray3D;

public class P3D
extends Plottable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DataArray3D data = new DataArray3D();
    private Color c;
    private int w;

    public P3D() {
        this("No title");
    }

    public P3D(String title) {
        this.title = title;
        this.c = Color.BLACK;
        this.w = 1;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public Color getPenColor() {
        return this.c;
    }

    public void setPenColor(Color c) {
        this.c = c;
    }

    public void setPenWidth(int w) {
        this.w = w;
    }

    public int getPenWidth() {
        return this.w;
    }

    public P3D(String title, String sfile) {
        this(title);
        this.read(sfile);
    }

    public int read(String sfile) {
        this.clear();
        try {
            String line;
            FileReader inF = new FileReader(new File(sfile));
            BufferedReader br = new BufferedReader(inF);
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.startsWith("*")) continue;
                StringTokenizer st = new StringTokenizer(line);
                int ncount = st.countTokens();
                double[] snum = new double[ncount];
                if (ncount != 6) {
                    this.ErrorMessage("Error in reading the file:\n" + Integer.toString(ncount) + " entries per line is found!");
                }
                int mm = 0;
                while (st.hasMoreTokens()) {
                    String tmp = st.nextToken();
                    double dd = 0.0;
                    try {
                        dd = Double.parseDouble(tmp.trim());
                    }
                    catch (NumberFormatException e) {
                        this.ErrorMessage("Error in reading the line " + Integer.toString(mm + 1));
                        return 3;
                    }
                    snum[mm] = dd;
                    ++mm;
                }
                this.data.addPoint(snum[0], snum[1], snum[2], snum[3], snum[4], snum[5]);
            }
            inF.close();
            br.close();
        }
        catch (FileNotFoundException e) {
            this.ErrorMessage("File not found!");
            e.printStackTrace();
            return 2;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public int writeSerialized(String name) {
        return Serialized.write(this, name);
    }

    public P3D readSerialized(String name) {
        return (P3D)Serialized.read(name);
    }

    public int readGZip(String sfile) {
        this.clear();
        try {
            String line;
            FileInputStream fin = new FileInputStream(sfile);
            GZIPInputStream gzis = new GZIPInputStream(fin);
            InputStreamReader xover = new InputStreamReader(gzis);
            BufferedReader is = new BufferedReader(xover);
            while ((line = is.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.startsWith("*")) continue;
                StringTokenizer st = new StringTokenizer(line);
                int ncount = st.countTokens();
                double[] snum = new double[ncount];
                if (ncount != 6) {
                    this.ErrorMessage("Error in reading the file:\n" + Integer.toString(ncount) + " entries per line is found!");
                    return 3;
                }
                int mm = 0;
                while (st.hasMoreTokens()) {
                    String tmp = st.nextToken();
                    double dd = 0.0;
                    try {
                        dd = Double.parseDouble(tmp.trim());
                    }
                    catch (NumberFormatException e) {
                        this.ErrorMessage("Error in reading the line " + Integer.toString(mm + 1));
                        return 3;
                    }
                    snum[mm] = dd;
                    ++mm;
                }
                this.data.addPoint(snum[0], snum[1], snum[2], snum[3], snum[4], snum[5]);
            }
            fin.close();
            is.close();
        }
        catch (FileNotFoundException e) {
            this.ErrorMessage("File not found!");
            e.printStackTrace();
            return 2;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public int readZip(String sfile) {
        this.clear();
        try {
            ZipFile zf = new ZipFile(sfile);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
            while (entries.hasMoreElements()) {
                String line;
                long size;
                ZipEntry ze = entries.nextElement();
                String inputLine = input.readLine();
                if (!inputLine.equalsIgnoreCase("yes") || (size = ze.getSize()) <= 0L) continue;
                BufferedReader br = new BufferedReader(new InputStreamReader(zf.getInputStream(ze)));
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#") || line.startsWith("*")) continue;
                    StringTokenizer st = new StringTokenizer(line);
                    int ncount = st.countTokens();
                    double[] snum = new double[ncount];
                    if (ncount != 6) {
                        this.ErrorMessage("Error in reading the file:\n" + Integer.toString(ncount) + " entries per line is found!");
                        return 3;
                    }
                    int mm = 0;
                    while (st.hasMoreTokens()) {
                        String tmp = st.nextToken();
                        double dd = 0.0;
                        try {
                            dd = Double.parseDouble(tmp.trim());
                        }
                        catch (NumberFormatException e) {
                            this.ErrorMessage("Error in reading the line " + Integer.toString(mm + 1));
                            return 3;
                        }
                        snum[mm] = dd;
                        ++mm;
                    }
                    this.data.addPoint(snum[0], snum[1], snum[2], snum[3], snum[4], snum[5]);
                }
                br.close();
            }
        }
        catch (FileNotFoundException e) {
            this.ErrorMessage("File not found:" + sfile);
            e.printStackTrace();
            return 1;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 2;
        }
        return 0;
    }

    public void toFile(String name) {
        DecimalFormat dfb = new DecimalFormat("##.#####E00");
        Date dat = new Date();
        String today = String.valueOf(dat);
        try {
            FileOutputStream f1 = new FileOutputStream(new File(name));
            PrintStream tx = new PrintStream(f1);
            tx.println("# DataMelt: output from P3D " + this.title);
            tx.println("# DataMelt: created at " + today);
            tx.println("# x,y,z");
            tx.println("#");
            for (int i = 0; i < this.size(); ++i) {
                String x = dfb.format(this.getX(i));
                String y = dfb.format(this.getY(i));
                String z = dfb.format(this.getZ(i));
                String dx = dfb.format(this.getDX(i));
                String dy = dfb.format(this.getDY(i));
                String dz = dfb.format(this.getDZ(i));
                tx.println(x + "  " + dx + "  " + y + "  " + dy + "  " + z + "  " + dz);
            }
            f1.close();
        }
        catch (IOException e) {
            this.ErrorMessage("Error in the output file");
            e.printStackTrace();
        }
    }

    public void print() {
        this.data.print();
    }

    public P3D merge(P3D a) {
        for (int i = 0; i < a.size(); ++i) {
            this.add(a.getX(i), a.getDX(i), a.getY(i), a.getDY(i), a.getZ(i), a.getDZ(i));
        }
        return this;
    }

    public void setDataArray(DataArray3D data) {
        this.data = data;
    }

    public DataArray3D getDataArray() {
        return this.data;
    }

    public void add(double x, double dx, double y, double dy, double z, double dz) {
        this.data.addPoint(x, dx, y, dy, z, dz);
    }

    public void set(int i, double x, double dx, double y, double dy, double z, double dz) {
        this.data.setPoint(i, x, dx, y, dy, z, dz);
    }

    public int size() {
        return this.data.size();
    }

    public P3D getCopy() {
        P3D tmp = new P3D(this.title);
        tmp.setPenColor(this.getPenColor());
        tmp.setPenWidth(this.getPenWidth());
        tmp.setDataArray(this.data);
        return tmp;
    }

    public double[] getArrayX() {
        double[] tmp = new double[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            tmp[i] = this.data.getX(i);
        }
        return tmp;
    }

    public double[] getArrayY() {
        double[] tmp = new double[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            tmp[i] = this.data.getY(i);
        }
        return tmp;
    }

    public double[] getArrayZ() {
        double[] tmp = new double[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            tmp[i] = this.data.getZ(i);
        }
        return tmp;
    }

    public double getX(int i) {
        return this.data.getX(i);
    }

    public double getDX(int i) {
        return this.data.getDX(i);
    }

    public double getY(int i) {
        return this.data.getY(i);
    }

    public double getDY(int i) {
        return this.data.getDY(i);
    }

    public double getZ(int i) {
        return this.data.getZ(i);
    }

    public double getDZ(int i) {
        return this.data.getDZ(i);
    }

    public double getMax(int axis) {
        return this.data.getMaxValue(axis);
    }

    public double getMin(int axis) {
        return this.data.getMinValue(axis);
    }

    public double meanX() {
        return this.data.meanX();
    }

    public double meanY() {
        return this.data.meanY();
    }

    public double meanZ() {
        return this.data.meanZ();
    }

    public void clear() {
        this.data.clear();
    }

    public void toTable() {
        new HTable(this);
    }

    private void ErrorMessage(String a) {
        Util.ErrorMessage((String)a);
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

