/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jhplot.HTable;
import jhplot.Plottable;
import jhplot.gui.HelpBrowser;
import jhplot.io.PReader;
import jhplot.io.Serialized;
import jhplot.utils.Util;
import jplot.DataArray2D;

public class P2D
extends Plottable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DoubleArrayList dataX = new DoubleArrayList();
    private DoubleArrayList dataY = new DoubleArrayList();
    private DoubleArrayList dataZ = new DoubleArrayList();
    private Color c;
    private int s;

    public P2D() {
        this("No title");
    }

    public P2D(String title) {
        this.title = title;
        this.c = Color.BLACK;
        this.s = 5;
    }

    public Color getSymbolColor() {
        return this.c;
    }

    public void setSymbolColor(Color c) {
        this.c = c;
    }

    public int getSymbolSize() {
        return this.s;
    }

    public int read(BufferedReader br) {
        this.clear();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.startsWith("*")) continue;
                StringTokenizer st = new StringTokenizer(line);
                int ncount = st.countTokens();
                double[] snum = new double[ncount];
                if (ncount != 3) {
                    this.ErrorMessage("Error in reading the file:\n" + Integer.toString(ncount) + " entries per line is found!");
                    return 3;
                }
                int mm = 0;
                while (st.hasMoreTokens()) {
                    String tmp = st.nextToken();
                    double dd = 0.0;
                    try {
                        dd = Double.parseDouble(tmp.trim());
                    }
                    catch (NumberFormatException e) {
                        this.ErrorMessage("Error in reading the line " + Integer.toString(mm + 1));
                        return 3;
                    }
                    snum[mm] = dd;
                    ++mm;
                }
                this.dataX.add(snum[0]);
                this.dataY.add(snum[1]);
                this.dataZ.add(snum[2]);
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            this.ErrorMessage("File not found!");
            e.printStackTrace();
            return 2;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public int read(File sfile) {
        BufferedReader is = PReader.read(sfile);
        if (is == null) {
            return 1;
        }
        return this.read(is);
    }

    public int read(URL url) {
        BufferedReader is = PReader.read(url);
        if (is == null) {
            return 1;
        }
        return this.read(is);
    }

    public int read(String sfile) {
        BufferedReader is = PReader.read(sfile);
        if (is == null) {
            return 1;
        }
        return this.read(is);
    }

    public int readGZip(String sfile) {
        BufferedReader is = PReader.readGZip(sfile);
        if (is == null) {
            return 1;
        }
        return this.read(is);
    }

    public int readZip(String sfile) {
        this.clear();
        try {
            ZipFile zf = new ZipFile(sfile);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
            while (entries.hasMoreElements()) {
                String line;
                long size;
                ZipEntry ze = entries.nextElement();
                String inputLine = input.readLine();
                if (!inputLine.equalsIgnoreCase("yes") || (size = ze.getSize()) <= 0L) continue;
                BufferedReader br = new BufferedReader(new InputStreamReader(zf.getInputStream(ze)));
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#") || line.startsWith("*")) continue;
                    StringTokenizer st = new StringTokenizer(line);
                    int ncount = st.countTokens();
                    double[] snum = new double[ncount];
                    if (ncount != 3) {
                        this.ErrorMessage("Error in reading the file:\n" + Integer.toString(ncount) + " entries per line is found!");
                        return 3;
                    }
                    int mm = 0;
                    while (st.hasMoreTokens()) {
                        String tmp = st.nextToken();
                        double dd = 0.0;
                        try {
                            dd = Double.parseDouble(tmp.trim());
                        }
                        catch (NumberFormatException e) {
                            this.ErrorMessage("Error in reading the line " + Integer.toString(mm + 1));
                            return 3;
                        }
                        snum[mm] = dd;
                        ++mm;
                    }
                    this.dataX.add(snum[0]);
                    this.dataY.add(snum[1]);
                    this.dataZ.add(snum[2]);
                }
                br.close();
            }
        }
        catch (FileNotFoundException e) {
            this.ErrorMessage("File not found:" + sfile);
            e.printStackTrace();
            return 1;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 2;
        }
        return 0;
    }

    public void setSymbolSize(int s) {
        this.s = s;
    }

    public P2D(String title, String sfile) {
        this(title);
        this.read(sfile);
    }

    public void toFile(String name) {
        DecimalFormat dfb = new DecimalFormat("##.#####E00");
        Date dat = new Date();
        String today = String.valueOf(dat);
        try {
            FileOutputStream f1 = new FileOutputStream(new File(name));
            PrintStream tx = new PrintStream(f1);
            tx.println("# DataMelt: output from P2D " + this.title);
            tx.println("# DataMelt: created at " + today);
            tx.println("# x,y,z");
            tx.println("#");
            for (int i = 0; i < this.size(); ++i) {
                String x = dfb.format(this.getX(i));
                String y = dfb.format(this.getY(i));
                String z = dfb.format(this.getZ(i));
                tx.println(x + "  " + y + "  " + z);
            }
            f1.close();
        }
        catch (IOException e) {
            this.ErrorMessage("Error in the output file");
            e.printStackTrace();
        }
    }

    public P2D merge(P2D a) {
        for (int i = 0; i < a.size(); ++i) {
            this.add(a.getX(i), a.getY(i), a.getZ(i));
        }
        return this;
    }

    public void setDataArray(DataArray2D data) {
        for (int i = 0; i < data.size(); ++i) {
            this.dataX.add(data.getX(i));
            this.dataY.add(data.getY(i));
            this.dataZ.add(data.getZ(i));
        }
    }

    public DataArray2D getDataArray() {
        DataArray2D data = new DataArray2D(this.size());
        for (int i = 0; i < this.size(); ++i) {
            data.addPoint(this.dataX.getQuick(i), this.dataY.getQuick(i), this.dataZ.getQuick(i));
        }
        return data;
    }

    public void add(double x, double y, double z) {
        this.dataX.add(x);
        this.dataY.add(y);
        this.dataZ.add(z);
    }

    public void fill(double[] xa, double[] ya, double[] za) {
        if (xa.length != ya.length) {
            System.out.println("Different dimensions of arrays!");
            return;
        }
        if (xa.length != za.length) {
            System.out.println("Different dimensions of arrays!");
            return;
        }
        this.dataX.elements(xa);
        this.dataY.elements(xa);
        this.dataZ.elements(xa);
    }

    public void set(int i, double x, double y, double z) {
        this.dataX.set(i, x);
        this.dataY.set(i, y);
        this.dataZ.set(i, z);
    }

    public int size() {
        return this.dataX.size();
    }

    public P2D copy() {
        return this.copy(this.title);
    }

    public String toString() {
        String s = new String();
        for (int i = 0; i < this.dataX.size(); ++i) {
            s = s + Double.toString(this.dataX.getQuick(i)) + "  " + Double.toString(this.dataY.getQuick(i)) + "  " + Double.toString(this.dataZ.getQuick(i)) + "\n";
        }
        return s;
    }

    public P2D copy(String newtitle) {
        P2D tmp = new P2D(newtitle);
        this.dataX = new DoubleArrayList();
        this.dataY = new DoubleArrayList();
        this.dataZ = new DoubleArrayList();
        this.dataX.clear();
        this.dataY.clear();
        this.dataZ.clear();
        for (int i = 0; i < this.size(); ++i) {
            this.dataX.add(this.getX(i));
            this.dataY.add(this.getY(i));
            this.dataZ.add(this.getZ(i));
        }
        tmp.setDoubleArrayLists(this.dataX, this.dataY, this.dataZ);
        return tmp;
    }

    public void setDoubleArrayLists(DoubleArrayList dataX2, DoubleArrayList dataY2, DoubleArrayList dataZ2) {
        this.dataX = dataX2;
        this.dataY = dataY2;
        this.dataZ = dataZ2;
    }

    public double[] getArrayX() {
        this.dataX.trimToSize();
        return this.dataX.elements();
    }

    public int writeSerialized(String name) {
        return Serialized.write(this, name);
    }

    public P2D readSerialized(String name) {
        return (P2D)Serialized.read(name);
    }

    public double[] getArrayY() {
        this.dataY.trimToSize();
        return this.dataY.elements();
    }

    public double[] getArrayZ() {
        this.dataZ.trimToSize();
        return this.dataZ.elements();
    }

    public double getX(int i) {
        return this.dataX.get(i);
    }

    public double getY(int i) {
        return this.dataY.get(i);
    }

    public double getZ(int i) {
        return this.dataZ.get(i);
    }

    public double getMax(int axis) {
        if (axis == 0) {
            return Descriptive.max((DoubleArrayList)this.dataX);
        }
        if (axis == 1) {
            return Descriptive.max((DoubleArrayList)this.dataY);
        }
        if (axis == 2) {
            return Descriptive.max((DoubleArrayList)this.dataZ);
        }
        return Descriptive.max((DoubleArrayList)this.dataX);
    }

    public double getMin(int axis) {
        if (axis == 0) {
            return Descriptive.min((DoubleArrayList)this.dataX);
        }
        if (axis == 1) {
            return Descriptive.min((DoubleArrayList)this.dataY);
        }
        if (axis == 2) {
            return Descriptive.min((DoubleArrayList)this.dataZ);
        }
        return Descriptive.min((DoubleArrayList)this.dataX);
    }

    public double meanX() {
        return Descriptive.mean((DoubleArrayList)this.dataX);
    }

    public double meanY() {
        return Descriptive.mean((DoubleArrayList)this.dataY);
    }

    public double meanZ() {
        return Descriptive.mean((DoubleArrayList)this.dataZ);
    }

    public double mean(int axis) {
        if (axis == 0) {
            return this.meanX();
        }
        if (axis == 1) {
            return this.meanY();
        }
        if (axis == 2) {
            return this.meanZ();
        }
        return -999999.0;
    }

    public void clear() {
        this.dataX.clear();
        this.dataY.clear();
        this.dataZ.clear();
    }

    public void toTable() {
        new HTable(this);
    }

    private void ErrorMessage(String a) {
        Util.ErrorMessage((String)a);
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

