/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import hep.aida.IAxis;
import hep.aida.ref.histogram.Histogram1D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import jhplot.F1D;
import jhplot.H1D;
import jhplot.P1D;
import jhplot.gui.CommonGUI;
import jhplot.gui.HelpBrowser;
import jhplot.io.images.ExportVGraphics;
import jplot.LinePars;
import org.jplot2d.element.Axis;
import org.jplot2d.element.AxisPosition;
import org.jplot2d.element.ElementFactory;
import org.jplot2d.element.Graph;
import org.jplot2d.element.Layer;
import org.jplot2d.element.Plot;
import org.jplot2d.element.Title;
import org.jplot2d.element.XYGraph;
import org.jplot2d.env.RenderEnvironment;
import org.jplot2d.renderer.EpsExporter;
import org.jplot2d.renderer.PdfExporter;
import org.jplot2d.renderer.PngFileExporter;
import org.jplot2d.renderer.Renderer;
import org.jplot2d.renderer.SVGExporter;
import org.jplot2d.renderer.SVGZExporter;
import org.jplot2d.sizing.FillContainerSizeMode;
import org.jplot2d.sizing.SizeMode;
import org.jplot2d.swing.JPlot2DComponent;
import org.jplot2d.transform.TransformType;
import org.jplot2d.util.Range;
import org.jplot2d.util.SymbolShape;

public class HPlotXY {
    private static final long serialVersionUID = 1L;
    private int xsize;
    private int ysize;
    private String title = "Tile";
    private JFrame frame;
    private static final String rootKey = HPlotXY.class.getName();
    private ElementFactory ef;
    private Plot plot;
    private Layer layer;
    private RenderEnvironment env;
    private Axis xaxis;
    private Axis yaxis;
    private Axis top_axis;
    private Axis right_axis;
    private JPlot2DComponent complot;

    public HPlotXY(String title, int xsize, int ysize, boolean set) {
        System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "ERROR");
        this.title = title;
        this.xsize = xsize;
        this.ysize = ysize;
        this.frame = new JFrame(title);
        this.ef = ElementFactory.getInstance();
        this.plot = this.ef.createPlot();
        this.plot.setSizeMode((SizeMode)new FillContainerSizeMode(1.0));
        this.plot.setFontSize(14.0f);
        JMenuBar bar = new JMenuBar();
        JMenu menu = new JMenu("File");
        JMenuItem item1 = new JMenuItem("Export");
        item1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HPlotXY.this.exportDialog();
            }
        });
        JMenuItem item2 = new JMenuItem("Close");
        item2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HPlotXY.this.close();
            }
        });
        this.frame.setDefaultCloseOperation(2);
        menu.add(item1);
        menu.add(item2);
        bar.add(menu);
        this.frame.setJMenuBar(bar);
        if (set) {
            this.top_axis = this.ef.createAxis();
            this.top_axis.setPosition(AxisPosition.POSITIVE_SIDE);
            this.top_axis.setLabelVisible(false);
            this.right_axis = this.ef.createAxis();
            this.right_axis.setPosition(AxisPosition.POSITIVE_SIDE);
            this.right_axis.setLabelVisible(false);
            this.xaxis = this.ef.createAxis();
            this.yaxis = this.ef.createAxis();
            this.xaxis.getTitle().setText("x");
            this.yaxis.getTitle().setText("y");
            this.xaxis.getTitle().setFont(new Font("Arial", 1, 18));
            this.yaxis.getTitle().setFont(new Font("Arial", 1, 18));
            this.plot.addXAxis(this.xaxis);
            this.plot.addYAxis(this.yaxis);
            this.plot.addXAxis(this.top_axis);
            this.plot.addYAxis(this.right_axis);
            this.layer = this.ef.createLayer();
            this.plot.addLayer(this.layer, this.xaxis.getTickManager().getAxisTransform(), this.yaxis.getTickManager().getAxisTransform());
        }
        this.env = new RenderEnvironment(true);
        this.env.setPlot(this.plot);
        this.complot = new JPlot2DComponent(this.env);
        this.frame.add((Component)this.complot);
        this.frame.setPreferredSize(new Dimension(xsize, ysize));
    }

    public HPlotXY(String title, int xsize, int ysize) {
        this(title, xsize, ysize, true);
    }

    public HPlotXY(boolean set) {
        this("Canvas", 600, 400, set);
    }

    public void setNameX(String s) {
        this.xaxis.getTitle().setText(s);
    }

    public void setNameY(String s) {
        this.yaxis.getTitle().setText(s);
    }

    public void setGTitle(String sname, Font f, Color c) {
        Title title = this.ef.createTitle(sname);
        title.setFont(f);
        title.setColor(c);
        this.plot.addTitle(title);
    }

    public void setGTitle(Title title) {
        this.plot.addTitle(title);
    }

    public void setGTitle(String sname, Color c) {
        this.setGTitle(sname, new Font("Arial", 1, 18), c);
    }

    public void setGTitle(String sname) {
        this.setGTitle(sname, new Font("Arial", 1, 18), Color.black);
    }

    public void setRangeX(double min, double max) {
        this.xaxis.getTickManager().getAxisTransform().setRange((Range)new Range.Double(min, max));
        this.top_axis.getTickManager().getAxisTransform().setRange((Range)new Range.Double(min, max));
    }

    public void setRangeY(double min, double max) {
        this.yaxis.getTickManager().getAxisTransform().setRange((Range)new Range.Double(min, max));
        this.right_axis.getTickManager().getAxisTransform().setRange((Range)new Range.Double(min, max));
    }

    public void setRange(double minX, double maxX, double minY, double maxY) {
        this.setRangeX(minX, maxX);
        this.setRangeY(minY, maxY);
    }

    public Axis getAxis(int axis) {
        if (axis == 0) {
            return this.xaxis;
        }
        if (axis == 1) {
            return this.yaxis;
        }
        if (axis == 10) {
            return this.top_axis;
        }
        if (axis == 11) {
            return this.right_axis;
        }
        return this.xaxis;
    }

    public void setAxis(Axis xaxis, Axis yaxis) {
        this.xaxis = xaxis;
        this.yaxis = yaxis;
    }

    public void setLogScale(int axis, boolean b) {
        if (b && axis == 0) {
            this.xaxis.getTickManager().getAxisTransform().setTransform(TransformType.LOGARITHMIC);
            this.top_axis.getTickManager().getAxisTransform().setTransform(TransformType.LOGARITHMIC);
        }
        if (b && axis == 1) {
            this.yaxis.getTickManager().getAxisTransform().setTransform(TransformType.LOGARITHMIC);
            this.right_axis.getTickManager().getAxisTransform().setTransform(TransformType.LOGARITHMIC);
        }
        if (!b && axis == 0) {
            this.xaxis.getTickManager().getAxisTransform().setTransform(TransformType.LINEAR);
            this.top_axis.getTickManager().getAxisTransform().setTransform(TransformType.LINEAR);
        }
        if (!b && axis == 1) {
            this.yaxis.getTickManager().getAxisTransform().setTransform(TransformType.LINEAR);
            this.right_axis.getTickManager().getAxisTransform().setTransform(TransformType.LINEAR);
        }
    }

    public void visible(boolean vs) {
        if (vs) {
            this.frame.pack();
            this.frame.setVisible(true);
        } else {
            this.frame.setVisible(false);
            this.frame.dispose();
        }
    }

    public void visible() {
        this.visible(true);
    }

    public HPlotXY(String title) {
        this(title, 600, 400, true);
    }

    public HPlotXY() {
        this("Default", 600, 400, true);
    }

    public void update() {
        this.complot.repaint();
    }

    public void export(String file) {
        int dot = file.lastIndexOf(46);
        String base = dot == -1 ? file : file.substring(0, dot);
        String fext = dot == -1 ? "" : file.substring(dot + 1);
        fext = fext.trim();
        boolean isSVGZ = false;
        if (fext.equalsIgnoreCase("svgz")) {
            isSVGZ = true;
        }
        boolean isEPS = false;
        if (fext.equalsIgnoreCase("eps")) {
            isEPS = true;
        }
        boolean isPDF = false;
        if (fext.equalsIgnoreCase("pdf")) {
            isPDF = true;
        }
        boolean isPNG = false;
        if (fext.equalsIgnoreCase("png")) {
            isPNG = true;
        }
        boolean isSVG = false;
        if (fext.equalsIgnoreCase("svg")) {
            isSVG = true;
        }
        boolean isJPG = false;
        if (fext.equalsIgnoreCase("jpg") || fext.equalsIgnoreCase("jpeg")) {
            isJPG = true;
        }
        try {
            if (isSVG) {
                this.env.exportPlot((Renderer)new SVGExporter(file));
            }
            if (isSVGZ) {
                this.env.exportPlot((Renderer)new SVGZExporter(file));
            }
            if (isPNG) {
                this.env.exportPlot((Renderer)new PngFileExporter(file));
            }
            if (isPDF) {
                this.env.exportPlot((Renderer)new PdfExporter(file));
            }
            if (isEPS) {
                this.env.exportPlot((Renderer)new EpsExporter(file));
            }
            if (isJPG) {
                this.env.exportPlot((Renderer)new PngFileExporter(file));
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }

    public String getTitle() {
        return this.title;
    }

    public void close() {
        this.frame.setVisible(false);
        this.plot = null;
        this.env = null;
        this.ef = null;
        this.frame.dispose();
    }

    public void draw(XYGraph xl) {
        this.layer.addGraph((Graph)xl);
    }

    public XYGraph draw(H1D histogram) {
        Histogram1D h1 = histogram.get();
        IAxis axis = h1.axis();
        int nbb = axis.bins() + 2;
        double[] xx = new double[nbb];
        double[] yy = new double[nbb];
        double[] xu = new double[nbb];
        double[] ye = new double[nbb];
        double[] xcenter = new double[nbb];
        for (int i = 1; i < axis.bins() + 1; ++i) {
            double xxx;
            double xl = histogram.binLowerEdge(i - 1);
            double xh = histogram.binUpperEdge(i - 1);
            double y = histogram.binHeight(i - 1);
            double y1 = histogram.binError(i - 1);
            double y2 = histogram.binError(i - 1);
            double cc = histogram.binCenter(i - 1);
            xx[i] = xxx = xl;
            yy[i] = y;
            ye[i] = y1;
            xcenter[i] = cc;
            xu[i] = xh;
        }
        double d = xcenter[axis.bins()] - xx[axis.bins()];
        xx[0] = histogram.binLowerEdge(0);
        yy[0] = 0.0;
        xx[nbb - 1] = xx[axis.bins()] + 2.0 * d;
        yy[nbb - 1] = 0.0;
        XYGraph graph = this.ef.createXYGraph((Object)xx, (Object)yy, null, null, null, null, histogram.getTitle());
        graph.setChartType(XYGraph.ChartType.HISTOGRAM_EDGE);
        graph.setSymbolVisible(false);
        graph.setSymbolSize(0.0f);
        if (histogram.isFilled()) {
            graph.setFillEnabled(true);
        }
        graph.setColor(histogram.getColor());
        Color cc = histogram.getFillColor();
        LinePars lpp = histogram.getDrawOption();
        float ff = lpp.getFillColorTransparency();
        graph.setFillPaint((Paint)cc);
        graph.setFillClosureType(XYGraph.FillClosureType.BOTTOM);
        this.layer.addGraph((Graph)graph);
        float width = histogram.getPenWidth();
        graph.setLineStroke(this.ef.createStroke(width));
        int lstyle = histogram.getLineStyle();
        if (lstyle == 1) {
            graph.setLineStroke(this.ef.createStroke(width, new float[]{12.0f, 6.0f}));
        }
        if (lstyle == 2) {
            graph.setLineStroke(this.ef.createStroke(width, new float[]{1.0f, 3.0f, 6.0f, 3.0f}));
        }
        if (lstyle == 3) {
            graph.setLineStroke(this.ef.createStroke(width, new float[]{6.0f, 6.0f}));
        }
        if (histogram.isErrY()) {
            XYGraph err = this.ef.createXYGraph((Object)xcenter, (Object)yy, null, null, (Object)ye, (Object)ye, histogram.getTitle() + "_Error");
            err.setSymbolVisible(true);
            err.setSymbolSize(0.0f);
            err.setFillEnabled(false);
            err.setLineVisible(false);
            err.getLegendItem().setVisible(false);
            this.layer.addGraph((Graph)err);
        }
        return graph;
    }

    public XYGraph draw(P1D p1d) {
        XYGraph xl = null;
        if (p1d.getDimension() == 2) {
            xl = this.ef.createXYGraph((Object)p1d.getArrayX(), (Object)p1d.getArrayY(), p1d.getTitle());
        }
        if (p1d.getDimension() == 3) {
            xl = this.ef.createXYGraph((Object)p1d.getArrayX(), (Object)p1d.getArrayY(), null, null, (Object)p1d.getArrayErr(), (Object)p1d.getArrayErr(), p1d.getTitle());
        }
        if (p1d.getDimension() == 4) {
            xl = this.ef.createXYGraph((Object)p1d.getArrayX(), (Object)p1d.getArrayY(), null, null, (Object)p1d.getArrayYlower(), (Object)p1d.getArrayYupper(), p1d.getTitle());
        }
        if (p1d.getDimension() > 5) {
            xl = this.ef.createXYGraph((Object)p1d.getArrayX(), (Object)p1d.getArrayY(), (Object)p1d.getArrayXleft(), (Object)p1d.getArrayXright(), (Object)p1d.getArrayYlower(), (Object)p1d.getArrayYupper(), p1d.getTitle());
        }
        xl.setSymbolShape(SymbolShape.FCIRCLE);
        xl.setColor(p1d.getColor());
        LinePars lpp = p1d.getDrawOption();
        int style = p1d.getLineStyle();
        float dash = lpp.getDashLength();
        int symbol = lpp.getSymbol();
        float width = p1d.getPenWidth();
        xl.setLineStroke(this.ef.createStroke(width));
        int lstyle = p1d.getLineStyle();
        if (lstyle == 1) {
            xl.setLineStroke(this.ef.createStroke(width, new float[]{12.0f, 6.0f}));
        }
        if (lstyle == 2) {
            xl.setLineStroke(this.ef.createStroke(width, new float[]{1.0f, 3.0f, 6.0f, 3.0f}));
        }
        if (lstyle == 3) {
            xl.setLineStroke(this.ef.createStroke(width, new float[]{6.0f, 6.0f}));
        }
        xl.setLineVisible(lpp.isDrawLine());
        xl.setSymbolVisible(lpp.isDrawSymbol());
        xl.setSymbolSize((float)((int)p1d.getSymbolSize()));
        xl.setSymbolColor(p1d.getColor());
        String sym = p1d.getSymbolShape();
        if (sym.equals("+")) {
            xl.setSymbolShape(SymbolShape.UARROW);
        } else if (sym.equals("Dot")) {
            xl.setSymbolShape(SymbolShape.FCIRCLE);
        } else if (sym.equals("Circle")) {
            xl.setSymbolShape(SymbolShape.FCIRCLE);
        } else if (sym.equals("o")) {
            xl.setSymbolShape(SymbolShape.CIRCLE);
        } else if (sym.equals("t")) {
            xl.setSymbolShape(SymbolShape.TRIANGLE);
        } else if (sym.equals("*")) {
            xl.setSymbolShape(SymbolShape.STAR);
        } else if (sym.equals("x")) {
            xl.setSymbolShape(SymbolShape.VCROSS);
        } else if (sym.equals("square")) {
            xl.setSymbolShape(SymbolShape.SQUARE);
        } else if (sym.equals("s")) {
            xl.setSymbolShape(SymbolShape.SQUARE);
        } else if (sym.equals("dot")) {
            xl.setSymbolShape(SymbolShape.FCIRCLE);
        } else if (sym.equals("diamond")) {
            xl.setSymbolShape(SymbolShape.DIAMOND);
        } else if (sym.equals("d")) {
            xl.setSymbolShape(SymbolShape.DIAMOND);
        } else {
            System.err.println("Unrecognizable symbol for drawing. HPlotXY supports: +, Dot, Circle, o, t, *, x, square, s, dot, diamond,d ");
        }
        this.layer.addGraph((Graph)xl);
        return xl;
    }

    public XYGraph draw(double[] x, double[] y, String name) {
        XYGraph xl = this.ef.createXYGraph((Object)x, (Object)y, name);
        xl.setLineVisible(false);
        xl.setSymbolVisible(true);
        xl.setSymbolShape(SymbolShape.FCIRCLE);
        this.layer.addGraph((Graph)xl);
        return xl;
    }

    public Plot getPlot() {
        return this.plot;
    }

    public JPlot2DComponent getPanel() {
        return this.complot;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public ElementFactory getFactory() {
        return this.ef;
    }

    public RenderEnvironment getEnv() {
        return this.env;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public XYGraph draw(F1D f1d) {
        if (f1d.getMin() == f1d.getMax()) {
            double x1 = this.xaxis.getTickManager().getAxisTransform().getRange().getMin();
            double x2 = this.xaxis.getTickManager().getAxisTransform().getRange().getMax();
            f1d.eval(x1, x2, f1d.getPoints());
        } else {
            f1d.eval(f1d.getMin(), f1d.getMax(), f1d.getPoints());
        }
        XYGraph xl = this.ef.createXYGraph((Object)f1d.getArrayX(), (Object)f1d.getArrayY(), f1d.getName());
        xl.setLineVisible(true);
        xl.setSymbolVisible(false);
        xl.setColor(f1d.getColor());
        float width = f1d.getPenWidth();
        xl.setLineStroke(this.ef.createStroke(width));
        int lstyle = f1d.getLineStyle();
        if (lstyle == 1) {
            xl.setLineStroke(this.ef.createStroke(width, new float[]{12.0f, 6.0f}));
        }
        if (lstyle == 2) {
            xl.setLineStroke(this.ef.createStroke(width, new float[]{1.0f, 3.0f, 6.0f, 3.0f}));
        }
        if (lstyle == 3) {
            xl.setLineStroke(this.ef.createStroke(width, new float[]{6.0f, 6.0f}));
        }
        this.layer.addGraph((Graph)xl);
        return xl;
    }

    private void exportDialog() {
        JFileChooser fc = CommonGUI.openImageFileChooser(this.frame);
        if (fc.showDialog(this.frame, "Export to ") == 0) {
            int res;
            final File scriptFile = ExportVGraphics.getSelectedFileWithExtension(fc);
            if (scriptFile == null) {
                return;
            }
            if (scriptFile.exists() && (res = JOptionPane.showConfirmDialog(this.frame, "The file exists. Do you want to overwrite the file?", "", 0)) == 1) {
                return;
            }
            String mess = "write image  file ..";
            Thread t = new Thread(mess){

                @Override
                public void run() {
                    HPlotXY.this.export(scriptFile.getAbsolutePath());
                }
            };
            t.start();
        }
    }
}

