/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IToolTipType;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ZoomableChart;
import info.monitorenter.gui.chart.controls.LayoutFactory;
import info.monitorenter.gui.chart.views.ChartPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import jhplot.gui.HelpBrowser;

public class HPlotRT {
    private static final long serialVersionUID = 1L;
    private ZoomableChart chart = new ZoomableChart();
    private JFrame frame;

    public HPlotRT(String title, int xsize, int ysize) {
        this.chart.setToolTipType((IToolTipType)Chart2D.ToolTipType.VALUE_SNAP_TO_TRACEPOINTS);
        this.chart.getAxisX().setPaintGrid(true);
        this.chart.getAxisY().setPaintGrid(true);
        ChartPanel chartpanel = new ChartPanel((Chart2D)this.chart);
        LayoutFactory factory = LayoutFactory.getInstance();
        this.frame = new JFrame(title);
        Container content = this.frame.getContentPane();
        content.add((Component)chartpanel);
        content.addPropertyChangeListener((PropertyChangeListener)chartpanel);
        this.frame.setJMenuBar(factory.createChartMenuBar(chartpanel, false));
        this.frame.setSize(xsize, ysize);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                HPlotRT.this.frame.setVisible(false);
                HPlotRT.this.frame.dispose();
                HPlotRT.this.chart = null;
            }
        });
        IAxis.AxisTitle ax1 = new IAxis.AxisTitle("X");
        ax1.setTitleFont(new Font("Arial", 1, 16));
        this.chart.getAxisX().setAxisTitle(ax1);
        IAxis.AxisTitle ax2 = new IAxis.AxisTitle("Y");
        ax2.setTitleFont(new Font("Arial", 1, 16));
        this.chart.getAxisY().setAxisTitle(ax2);
        this.frame.setVisible(true);
    }

    public IAxis<?> getAxisX() {
        return this.chart.getAxisX();
    }

    public IAxis<?> getAxisY() {
        return this.chart.getAxisY();
    }

    public HPlotRT(String title) {
        this(title, 600, 400);
    }

    public HPlotRT() {
        this("Default", 600, 400);
    }

    public void add(ITrace2D trace) {
        this.chart.addTrace(trace);
    }

    public Chart2D getChart() {
        return this.chart;
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }

    public void close() {
        this.frame.setVisible(false);
        this.frame.dispose();
        this.chart = null;
    }

    public void quit() {
        this.close();
    }
}

