/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import jhplot.gui.HelpBrowser;
import org.scilab.forge.jlatexmath.ParseException;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;

public class HLatexEq {
    private static final long serialVersionUID = 1L;
    private TeXFormula formula;
    private TeXIcon icon;
    private Color background = Color.white;
    private Color foreground = Color.black;

    public HLatexEq(String latex, int size, Color foreground, Color background) {
        this.background = background;
        this.foreground = foreground;
        try {
            this.formula = new TeXFormula(latex);
            this.icon = this.formula.createTeXIcon(0, (float)size);
            this.icon.setInsets(new Insets(5, 5, 5, 5));
        }
        catch (ParseException ex) {
            System.err.println(ex.toString());
        }
    }

    public HLatexEq(String latex, int size) {
        this(latex, size, Color.black, Color.white);
    }

    public HLatexEq(String latex) {
        this(latex, 20, Color.black, Color.white);
    }

    public TeXFormula getEquation() {
        return this.formula;
    }

    public TeXIcon getIcon() {
        return this.icon;
    }

    public void export(String filename) {
        BufferedImage image = new BufferedImage(this.icon.getIconWidth(), this.icon.getIconHeight(), 2);
        Graphics2D g2 = image.createGraphics();
        g2.setColor(this.background);
        g2.fillRect(0, 0, this.icon.getIconWidth(), this.icon.getIconHeight());
        JLabel jl = new JLabel();
        jl.setForeground(this.foreground);
        this.icon.paintIcon((Component)jl, (Graphics)g2, 0, 0);
        File file = new File(filename);
        try {
            ImageIO.write((RenderedImage)image, "png", file.getAbsoluteFile());
        }
        catch (IOException ex) {
            System.err.println(ex.toString());
        }
    }

    public void export() {
        this.export("equation.png");
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

