/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import cambria.CABatch;
import cambria.CAConfig;
import cambria.CAGraphics;
import cambria.CARule;
import cambria.CASearch;
import cambria.CanonicalRule;
import cambria.CheckRule;
import cambria.Demon;
import cambria.InteractingEnergy;
import cambria.RuleSwitcher;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import jhplot.gui.HelpBrowser;

public class HCellular {
    private CAConfig caConfig;
    private CARule rule;
    private String srule = "";
    private String X_MAX;
    private String Y_MAX;
    private String T_MAX;
    private String DeltaTime;
    private String CellSize;
    private String RuleClass = null;
    private String RuleString;
    private String RuleFile;
    private String InitType = null;
    private String InitFile = null;
    private String ThreadName = null;
    private String Torus = null;
    private String UserMode = "GUI";
    private String BatchNumber;
    private String RunNumber;
    private String PopulationSize = null;
    private String EliteSize = null;
    private String GoalOfHs = null;
    private String MutationRate = null;
    private String CrossoverRate = null;
    private String MaxIter = null;
    private ArrayList<String> RuleClasses;

    public HCellular() {
        this.setDefault();
        this.RuleClasses = new ArrayList();
        this.RuleClasses.add("Aggregation");
        this.RuleClasses.add("Aqua");
        this.RuleClasses.add("AquaP2");
        this.RuleClasses.add("BlockVN");
        this.RuleClasses.add("Check24");
        this.RuleClasses.add("Check29");
        this.RuleClasses.add("Check35");
        this.RuleClasses.add("Check25ByGA");
        this.RuleClasses.add("CyclicCA8");
        this.RuleClasses.add("CyclicCA14");
        this.RuleClasses.add("VN");
        this.RuleClasses.add("Life");
        this.RuleClasses.add("Life2");
        this.RuleClasses.add("Generation");
        this.RuleClasses.add("GMBrain");
        this.RuleClasses.add("Hodge");
        this.RuleClasses.add("Ising");
        this.RuleClasses.add("Stripe");
    }

    public ArrayList<String> getRules() {
        return this.RuleClasses;
    }

    public String getRule() {
        return this.srule;
    }

    public void visible() {
        this.setNonGraphicItems();
        String UserMode = this.getUserModeString();
        if (UserMode == null) {
            UserMode = "GUI";
        }
        if (UserMode.regionMatches(true, 0, "Batch", 0, 5)) {
            int batchNumber = this.getBatchNumber();
            String runNumber = this.getRunNumber();
            int t_max = this.getTMax();
            CAConfig caConfig = this.getCAConfig();
            CABatch.executeBatchJob((CAConfig)caConfig, (int)batchNumber, (String)runNumber, (int)t_max);
        } else if (UserMode.regionMatches(true, 0, "GUI", 0, 3) || UserMode.regionMatches(true, 0, "Demo", 0, 4)) {
            int cellSize = this.getCellSize();
            int deltaTime = this.getDeltaTime();
            CAConfig caConfig = this.getCAConfig();
            CAGraphics cAGraphics = new CAGraphics(caConfig, cellSize, deltaTime, UserMode);
        } else if (UserMode.regionMatches(true, 0, "Search", 0, 6)) {
            int populationSize = this.getPopulationSize();
            int eliteSize = this.getEliteSize();
            double mutationRate = this.getMutationRate();
            double crossoverRate = this.getCrossoverRate();
            int maxIter = this.getMaxIter();
            double goalOfHs = this.getGoalOfHs();
            String runNumber = this.getRunNumber();
            CAConfig caConfig = this.getCAConfig();
            CASearch caSearch = new CASearch(caConfig, populationSize, eliteSize, mutationRate, crossoverRate, maxIter, goalOfHs, runNumber);
            caSearch.start();
        } else {
            throw new RuntimeException("Invalid parameter of UserMode");
        }
    }

    public void setInitString(String RuleString) {
        this.RuleString = RuleString;
    }

    public String getInitString() {
        return this.RuleString;
    }

    public void doc() {
        URL url = CARule.class.getResource("doc/readme.html");
        new HelpBrowser(url);
    }

    public void setInitFile(String RuleFile) {
        this.RuleFile = RuleFile;
    }

    public boolean setRule(String rule) {
        if (this.RuleClasses.contains(rule)) {
            if (rule == "VN") {
                this.RuleString = this.getInitJar("cyclic8.rul");
                return true;
            }
            if (rule == "BlockVN") {
                this.RuleString = this.getInitJar("sandOpt01.par");
                return true;
            }
            if (rule == "Aggregation") {
                rule = "BlockVN";
                this.RuleString = this.getInitJar("sandOpt01.par");
                return true;
            }
            if (rule == "Stripe") {
                rule = "BlockVN";
                this.RuleString = this.getInitJar("strOpt01.par");
                return true;
            }
            if (rule == "Check29") {
                rule = "Block9";
                this.RuleString = this.getInitJar("moore2cry.par");
                return true;
            }
            if (rule == "Check24") {
                rule = "Block4";
                this.RuleString = this.getInitJar("acrystal24.par");
                return true;
            }
            if (rule == "Check35") {
                rule = "BlockVN";
                this.RuleString = this.getInitJar("acrystal35.par");
                return true;
            }
            if (rule == "Check25ByGA") {
                rule = "BlockVN";
                this.RuleString = this.getInitJar("cryOpt01.par");
                return true;
            }
            if (rule == "CyclicCA8") {
                rule = "VN";
                this.RuleString = this.getInitJar("cyclic8.rul");
                return true;
            }
            if (rule == "CyclicCA14") {
                rule = "VN";
                this.RuleString = this.getInitJar("cyclic14.rul");
                return true;
            }
            this.srule = rule;
            this.RuleClass = "cambria." + rule + "Rule";
            return true;
        }
        return false;
    }

    public CAConfig getCAConfig() {
        return this.caConfig;
    }

    public void setNonGraphicItems() {
        int y_max;
        int x_max;
        this.rule = CARule.createRule((String)this.RuleClass);
        if (!(this.rule instanceof RuleSwitcher)) {
            this.rule.setRule(this.RuleString, this.RuleFile);
        } else {
            int statePerCell = 2;
            int maxRuleSelection = 2;
            ((RuleSwitcher)this.rule).initializeRuleArray(statePerCell, maxRuleSelection);
            this.rule.setRule(this.RuleString, this.RuleFile);
        }
        boolean torus = HCellular.getTorus(this.Torus);
        if (this.ThreadName == null) {
            this.ThreadName = this.rule.getDefaultThread();
        }
        if (this.InitFile != null) {
            if (this.X_MAX != null || this.Y_MAX != null || this.InitType != null) {
                System.out.println("Warning: Some parameters are interfared. ");
            }
            this.caConfig = new CAConfig(this.rule, torus, this.isSynchronous(this.ThreadName), this.InitFile);
            x_max = this.caConfig.getXMax();
            y_max = this.caConfig.getYMax();
        } else {
            x_max = HCellular.convertIntParameter(this.X_MAX, 100);
            y_max = HCellular.convertIntParameter(this.Y_MAX, 100);
            this.caConfig = new CAConfig(this.rule, torus, this.InitType, this.isSynchronous(this.ThreadName), x_max, y_max);
        }
        if (this.rule instanceof InteractingEnergy) {
            if (this.rule instanceof CanonicalRule || this.rule instanceof CheckRule) {
                Demon demon = new Demon(x_max, y_max, 0, 1, 5);
                ((InteractingEnergy)this.rule).setDemon(demon);
            } else {
                Demon demon = new Demon(x_max, y_max);
                ((InteractingEnergy)this.rule).setDemon(demon);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean getTorus(String Torus) {
        if (Torus == null) return true;
        if (Torus.equals("false")) return false;
        if (Torus.equals("False")) {
            return false;
        }
        if (Torus.equals("true")) return true;
        if (!Torus.equals("True")) throw new IllegalArgumentException("Invalid torus argument");
        return true;
    }

    public void setDefault() {
        this.T_MAX = "200";
        this.X_MAX = "400";
        this.Y_MAX = "200";
        this.DeltaTime = "25";
        this.CellSize = "3";
        this.RuleClass = "cambria.LifeRule";
        this.RuleString = null;
        this.RuleFile = null;
        this.ThreadName = null;
        this.InitType = null;
        this.InitFile = null;
        this.Torus = null;
        this.UserMode = "GUI";
        this.BatchNumber = "1";
        this.RunNumber = null;
        this.PopulationSize = "30";
        this.EliteSize = "20";
        this.GoalOfHs = null;
        this.MutationRate = "0.005";
        this.CrossoverRate = "0.005";
        this.MaxIter = "10000";
    }

    public String getUserModeString() {
        return this.UserMode;
    }

    private boolean isSynchronous(String ThreadName) {
        if (ThreadName == null) {
            return true;
        }
        if (ThreadName.regionMatches(true, 0, "MCSThread", 0, 9)) {
            return false;
        }
        if (ThreadName.regionMatches(true, 0, "CAThread", 0, 8)) {
            return true;
        }
        throw new IllegalArgumentException("No such parameter.");
    }

    public int getDeltaTime() {
        return HCellular.convertIntParameter(this.DeltaTime, 25);
    }

    public void setDetltaTime(int i) {
        this.DeltaTime = Integer.toBinaryString(i);
    }

    public int getCellSize() {
        return HCellular.convertIntParameter(this.CellSize, 3);
    }

    public void setCellSize(int i) {
        this.CellSize = Integer.toBinaryString(i);
    }

    public int getTMax() {
        return HCellular.convertIntParameter(this.T_MAX, 200);
    }

    public int getBatchNumber() {
        return HCellular.convertIntParameter(this.BatchNumber, 1);
    }

    public String getRunNumber() {
        return this.RunNumber;
    }

    public int getPopulationSize() {
        return HCellular.convertIntParameter(this.PopulationSize, 20);
    }

    public void setPopulationSize(int i) {
        this.PopulationSize = Integer.toBinaryString(i);
    }

    public int getEliteSize() {
        return HCellular.convertIntParameter(this.EliteSize, 20);
    }

    public double getMutationRate() {
        return HCellular.convertDoubleParameter(this.MutationRate, 0.005);
    }

    public double getCrossoverRate() {
        return HCellular.convertDoubleParameter(this.CrossoverRate, 0.005);
    }

    public int getMaxIter() {
        return HCellular.convertIntParameter(this.MaxIter, 1000);
    }

    public double getGoalOfHs() {
        return HCellular.convertDoubleParameter(this.GoalOfHs, 0.6);
    }

    public static int convertIntParameter(String string, int defaultValue) {
        int intParameter = 0;
        if (string != null) {
            try {
                intParameter = Integer.parseInt(string);
            }
            catch (NumberFormatException e) {
                intParameter = defaultValue;
                System.out.print("'" + string + "' is not an integer. ");
                System.out.println("Check input parameters.");
            }
        } else {
            intParameter = defaultValue;
        }
        return intParameter;
    }

    public static double convertDoubleParameter(String string, double defaultValue) {
        double doubleParameter = 0.0;
        if (string != null) {
            try {
                doubleParameter = new Double(string);
            }
            catch (NumberFormatException e) {
                System.out.print("'" + string + "' is not a double. ");
                System.out.println("Check input parameters.");
                doubleParameter = defaultValue;
            }
        } else {
            doubleParameter = defaultValue;
        }
        return doubleParameter;
    }

    private String getInitJar(String what) {
        return this.readTextFromJar(what);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readTextFromJar(String s) {
        InputStream is = null;
        BufferedReader br = null;
        String sline = "";
        try {
            String line;
            is = CARule.class.getResourceAsStream("resources/" + s);
            br = new BufferedReader(new InputStreamReader(is));
            while (null != (line = br.readLine())) {
                sline = sline + line + "\n";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sline;
    }
}

