/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.MarkerVertex;
import java.awt.Graphics;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.Vector;

public class Markers {
    protected int last = 0;
    protected int max = 10;
    protected Vector[] vert = new Vector[this.max];

    public Markers() {
    }

    public Markers(URL file) throws IOException {
        this();
        this.LoadMarkers(file);
    }

    public void AddMarker(int m, int n, boolean[] draw, int[] x, int[] y) {
        if (m < 1 || m > this.max) {
            return;
        }
        if (n <= 0) {
            return;
        }
        this.last = --m;
        this.vert[m] = new Vector();
        for (int i = 0; i < n; ++i) {
            MarkerVertex v = new MarkerVertex();
            v.draw = draw[i];
            v.x = x[i];
            v.y = y[i];
            this.vert[m].addElement(v);
        }
    }

    public void AddMarker(int n, boolean[] draw, int[] x, int[] y) {
        this.AddMarker(this.last + 1, n, draw, x, y);
    }

    public void DeleteMarker(int n) {
        if (n < 1 || n > this.max) {
            return;
        }
        this.vert[n - 1] = null;
    }

    public void ClearMarkers() {
        if (this.last == 0) {
            return;
        }
        for (int i = 0; i < this.max; ++i) {
            this.vert[i] = null;
        }
        this.last = 0;
    }

    public void LoadMarkers(URL file) throws IOException {
        InputStream is = file.openStream();
        StreamTokenizer st = new StreamTokenizer(is);
        st.eolIsSignificant(true);
        st.commentChar(35);
        block4: while (true) {
            switch (st.nextToken()) {
                default: {
                    break block4;
                }
                case 10: {
                    continue block4;
                }
                case -3: {
                    MarkerVertex v;
                    if ("start".equals(st.sval)) {
                        this.vert[this.last] = new Vector();
                        continue block4;
                    }
                    if ("end".equals(st.sval)) {
                        ++this.last;
                        continue block4;
                    }
                    if ("m".equals(st.sval)) {
                        v = new MarkerVertex();
                        v.draw = false;
                        if (st.nextToken() != -2) continue block4;
                        v.x = (int)st.nval;
                        if (st.nextToken() != -2) continue block4;
                        v.y = (int)st.nval;
                        this.vert[this.last].addElement(v);
                        continue block4;
                    }
                    if (!"l".equals(st.sval)) continue block4;
                    v = new MarkerVertex();
                    v.draw = true;
                    if (st.nextToken() != -2) continue block4;
                    v.x = (int)st.nval;
                    if (st.nextToken() != -2) continue block4;
                    v.y = (int)st.nval;
                    this.vert[this.last].addElement(v);
                    continue block4;
                }
            }
            break;
        }
        is.close();
    }

    public void draw(Graphics g, int m, double scale, int x, int y) {
        int x0 = x;
        int x1 = x;
        int y0 = y;
        int y1 = y;
        if (m < 1 || m > this.max) {
            return;
        }
        if (scale <= 0.0) {
            return;
        }
        Vector v = this.vert[m - 1];
        if (v == null) {
            return;
        }
        for (int i = 0; i < v.size(); ++i) {
            MarkerVertex mv = (MarkerVertex)v.elementAt(i);
            if (mv.draw) {
                x1 = x + (int)((double)mv.x * scale);
                y1 = y + (int)((double)mv.y * scale);
                g.drawLine(x0, y0, x1, y1);
                x0 = x1;
                y0 = y1;
                continue;
            }
            x0 = x + (int)((double)mv.x * scale);
            y0 = y + (int)((double)mv.y * scale);
        }
    }
}

