/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.util.io;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.neuroph.util.io.InputAdapter;
import org.neuroph.util.io.NeurophInputException;

public class JDBCInputAdapter
implements InputAdapter {
    ResultSet resultSet;
    int inputSize;

    public JDBCInputAdapter(Connection connection, String sql) {
        try {
            Statement stmt = connection.createStatement();
            this.resultSet = stmt.executeQuery(sql);
            ResultSetMetaData rsmd = this.resultSet.getMetaData();
            this.inputSize = rsmd.getColumnCount();
        }
        catch (SQLException ex) {
            Logger.getLogger(JDBCInputAdapter.class.getName()).log(Level.SEVERE, null, ex);
            throw new NeurophInputException("Error executing query at JdbcInputAdapter", ex);
        }
    }

    @Override
    public double[] readInput() {
        try {
            if (this.resultSet.next()) {
                double[] inputBuffer = new double[this.inputSize];
                for (int i = 1; i <= this.inputSize; ++i) {
                    inputBuffer[i - 1] = this.resultSet.getDouble(i);
                }
                return inputBuffer;
            }
        }
        catch (SQLException ex) {
            throw new NeurophInputException("Error reading input value from the result set!", ex);
        }
        return null;
    }

    @Override
    public void close() {
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        catch (SQLException ex) {
            throw new NeurophInputException("Error closing database connection!", ex);
        }
    }
}

