/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.util;

import java.util.Iterator;
import org.neuroph.core.Neuron;
import org.neuroph.core.input.InputFunction;
import org.neuroph.core.input.WeightedSum;
import org.neuroph.core.transfer.Linear;
import org.neuroph.core.transfer.TransferFunction;
import org.neuroph.util.Properties;
import org.neuroph.util.TransferFunctionType;

public class NeuronProperties
extends Properties {
    private static final long serialVersionUID = 2L;

    public NeuronProperties() {
        this.initKeys();
        this.setProperty("inputFunction", WeightedSum.class);
        this.setProperty("transferFunction", Linear.class);
        this.setProperty("neuronType", Neuron.class);
    }

    public NeuronProperties(Class<? extends Neuron> neuronClass) {
        this.initKeys();
        this.setProperty("inputFunction", WeightedSum.class);
        this.setProperty("transferFunction", Linear.class);
        this.setProperty("neuronType", neuronClass);
    }

    public NeuronProperties(Class<? extends Neuron> neuronClass, Class<? extends TransferFunction> transferFunctionClass) {
        this.initKeys();
        this.setProperty("inputFunction", WeightedSum.class);
        this.setProperty("transferFunction", transferFunctionClass);
        this.setProperty("neuronType", neuronClass);
    }

    public NeuronProperties(Class<? extends Neuron> neuronClass, Class<? extends InputFunction> inputFunctionClass, Class<? extends TransferFunction> transferFunctionClass) {
        this.initKeys();
        this.setProperty("inputFunction", inputFunctionClass);
        this.setProperty("transferFunction", transferFunctionClass);
        this.setProperty("neuronType", neuronClass);
    }

    public NeuronProperties(Class<? extends Neuron> neuronClass, TransferFunctionType transferFunctionType) {
        this.initKeys();
        this.setProperty("inputFunction", WeightedSum.class);
        this.setProperty("transferFunction", transferFunctionType.getTypeClass());
        this.setProperty("neuronType", neuronClass);
    }

    public NeuronProperties(TransferFunctionType transferFunctionType, boolean useBias) {
        this.initKeys();
        this.setProperty("inputFunction", WeightedSum.class);
        this.setProperty("transferFunction", transferFunctionType.getTypeClass());
        this.setProperty("useBias", useBias);
        this.setProperty("neuronType", Neuron.class);
    }

    private void initKeys() {
        this.createKeys("inputFunction", "transferFunction", "neuronType", "useBias");
    }

    public Class getInputFunction() {
        Object val = this.get("inputFunction");
        if (!val.equals("")) {
            return (Class)val;
        }
        return null;
    }

    public Class getTransferFunction() {
        return (Class)this.get("transferFunction");
    }

    public Class getNeuronType() {
        return (Class)this.get("neuronType");
    }

    public Properties getTransferFunctionProperties() {
        Properties tfProperties = new Properties();
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            String name = iterator.next().toString();
            if (!name.contains("transferFunction")) continue;
            tfProperties.setProperty(name, this.get(name));
        }
        return tfProperties;
    }

    @Override
    public final void setProperty(String key, Object value) {
        if (value instanceof TransferFunctionType) {
            value = ((TransferFunctionType)((Object)value)).getTypeClass();
        }
        this.put(key, value);
    }
}

