/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.samples.mnist.master;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.data.DataSet;
import org.neuroph.eval.classification.ClassificationResult;
import org.neuroph.eval.classification.Utils;
import org.neuroph.samples.convolution.mnist.MNISTDataSet;

public class FuNet1
extends JFrame
implements Runnable {
    private BufferedImage canvas;
    private NeuralNetwork network;
    DataSet testSet;
    private JLabel label;
    int currentX;
    int currentY;
    int oldX;
    int oldY;
    int tool = 1;
    double value = 40.0;
    int color = 1;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    public JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JRadioButton jRadioButton3;
    private JRadioButton jRadioButton4;
    private JRadioButton jRadioButton5;
    private JRadioButton jRadioButton6;
    private JRadioButton jRadioButton7;
    private JRadioButton jRadioButton8;
    public JSlider jSlider2;
    int[] pixels;
    double[] newPix;

    public FuNet1() {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.network = NeuralNetwork.load(new FileInputStream("/home/mithquissir/Desktop/cnn/5-50-100/30.nnet"));
            this.testSet = MNISTDataSet.createFromFile("data_sets/t10k-labels.idx1-ubyte", "data_sets/t10k-images.idx3-ubyte", 10000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initComponents();
    }

    public void updateCanvas() {
        Graphics2D g2 = this.canvas.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setPaint(this.getColor());
        if (this.tool == 1) {
            g2.fillOval(this.currentX - (int)this.value / 2, this.currentY - (int)this.value / 2, (int)this.value, (int)this.value);
        } else if (this.tool == 2) {
            g2.setStroke(new BasicStroke((float)this.value, 1, 1));
            g2.drawLine(this.oldX, this.oldY, this.currentX, this.currentY);
            g2.setStroke(new BasicStroke(1.0f));
        }
        this.repaint();
    }

    private Color getColor() {
        Color c = null;
        if (this.color == 1) {
            c = Color.black;
        } else if (this.color == 2) {
            c = new Color(240, 240, 240);
        } else if (this.color == 3) {
            c = Color.white;
        } else if (this.color == 4) {
            c = Color.red;
        } else if (this.color == 5) {
            c = Color.green;
        } else if (this.color == 6) {
            c = Color.blue;
        }
        return c;
    }

    private void initComponents() {
        this.canvas = new BufferedImage(320, 320, 10);
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jPanel4 = new JPanel();
        this.jSlider2 = new JSlider();
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel(new GridBagLayout());
        JLabel canvasLabel = new JLabel(new ImageIcon(this.canvas));
        this.jPanel2.add((Component)canvasLabel, null);
        this.jPanel3 = new JPanel();
        this.jRadioButton3 = new JRadioButton();
        this.jRadioButton4 = new JRadioButton();
        this.jRadioButton5 = new JRadioButton();
        this.jRadioButton6 = new JRadioButton();
        this.jRadioButton7 = new JRadioButton();
        this.jRadioButton8 = new JRadioButton();
        this.jButton1 = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("FuNet1 --- powered by Neuroph");
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Line thickness"));
        this.jSlider2.setMajorTickSpacing(10);
        this.jSlider2.setMaximum(51);
        this.jSlider2.setMinimum(1);
        this.jSlider2.setMinorTickSpacing(5);
        this.jSlider2.setPaintTicks(true);
        this.jSlider2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FuNet1.this.jSlider2StateChanged(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 51, Short.MAX_VALUE).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent(this.jSlider2, -2, 150, -2)).addContainerGap()));
        this.label = new JLabel("");
        Font labelFont = this.label.getFont();
        this.label.setFont(new Font(labelFont.getName(), 0, 30));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSlider2, -2, -1, -2).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED))));
        this.jPanel2.setBackground(new Color(0, 0, 0));
        this.jPanel2.setBorder(BorderFactory.createBevelBorder(0));
        canvasLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                FuNet1.this.jPanel2MousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                FuNet1.this.jPanel2MouseReleased(evt);
            }
        });
        canvasLabel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                FuNet1.this.jPanel2MouseDragged(evt);
            }
        });
        this.jButton1.setText("Clear");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FuNet1.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1, -1, 112, Short.MAX_VALUE).addComponent(this.label, -1, 112, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.jButton1, -2, 30, -2).addComponent(this.label, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        Graphics g = this.canvas.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.canvas.getWidth(), this.canvas.getHeight());
        this.repaint();
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        Graphics g = this.canvas.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.canvas.getWidth(), this.canvas.getHeight());
        this.repaint();
    }

    private void jPanel2MouseDragged(MouseEvent evt) {
        this.currentX = evt.getX();
        this.currentY = evt.getY();
        this.updateCanvas();
        if (this.tool == 1) {
            this.oldX = this.currentX;
            this.oldY = this.currentY;
        }
    }

    private void jPanel2MousePressed(MouseEvent evt) {
        this.oldX = evt.getX();
        this.oldY = evt.getY();
        if (this.tool == 2) {
            this.currentX = this.oldX;
            this.currentY = this.oldY;
        }
    }

    private void jSlider2StateChanged(ChangeEvent evt) {
        this.value = this.jSlider2.getValue();
    }

    private void jPanel2MouseReleased(MouseEvent evt) {
        this.currentX = evt.getX();
        this.currentY = evt.getY();
        double SCALE = 0.1;
        BufferedImage bi = new BufferedImage(32, 32, 10);
        Graphics2D grph = (Graphics2D)bi.getGraphics();
        grph.scale(0.1, 0.1);
        grph.drawImage((Image)this.canvas, 0, 0, null);
        grph.dispose();
        this.newPix = new double[1024];
        this.pixels = bi.getRGB(0, 0, 32, 32, this.pixels, 0, 32);
        int i = 0;
        while (i < this.pixels.length) {
            this.newPix[i] = 255 - (this.pixels[i] & 0xFF);
            int n = i++;
            this.newPix[n] = this.newPix[n] / 255.0;
        }
        long start = System.currentTimeMillis();
        this.network.setInput(this.newPix);
        this.network.calculate();
        System.out.println("Execution time: " + (System.currentTimeMillis() - start) + " milliseconds");
        try {
            ImageIO.write((RenderedImage)bi, "png", new File("number.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        double[] networkOutput = this.network.getOutput();
        int maxNeuronIdx = Utils.maxIdx(networkOutput);
        ClassificationResult max = new ClassificationResult(maxNeuronIdx, networkOutput[maxNeuronIdx]);
        System.out.println("New calculation:");
        System.out.println("Class: " + max.getClassIdx());
        System.out.println("Probability: " + max.getNeuronOutput());
        this.label.setText(String.valueOf(max.getClassIdx()));
    }

    public static void main(String[] args) {
        final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FuNet1 net = new FuNet1();
                scheduler.scheduleAtFixedRate(net, 0L, 300L, TimeUnit.MILLISECONDS);
                net.setVisible(true);
            }
        });
    }

    @Override
    public void run() {
    }
}

