/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.learning;

import java.util.Iterator;
import org.neuroph.core.Connection;
import org.neuroph.core.Layer;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.Neuron;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.data.DataSetRow;
import org.neuroph.core.events.LearningEvent;
import org.neuroph.core.learning.LearningRule;

public class KohonenLearning
extends LearningRule {
    private static final long serialVersionUID = 1L;
    double learningRate = 0.9;
    int[] iterations = new int[]{100, 0};
    double[] decStep = new double[2];
    int mapSize = 0;
    int[] nR = new int[]{1, 1};
    int currentIteration;

    @Override
    public void learn(DataSet trainingSet) {
        for (int phase = 0; phase < 2; ++phase) {
            int k = 0;
            while (k < this.iterations[phase]) {
                Iterator<DataSetRow> iterator = trainingSet.iterator();
                while (iterator.hasNext() && !this.isStopped()) {
                    DataSetRow trainingSetRow = iterator.next();
                    this.learnPattern(trainingSetRow, this.nR[phase]);
                }
                this.currentIteration = k++;
                this.fireLearningEvent(new LearningEvent(this, LearningEvent.Type.EPOCH_ENDED));
                if (!this.isStopped()) continue;
                return;
            }
            this.learningRate *= 0.5;
        }
    }

    private void learnPattern(DataSetRow dataSetRow, int neighborhood) {
        this.neuralNetwork.setInput(dataSetRow.getInput());
        this.neuralNetwork.calculate();
        Neuron winner = this.getClosestNeuron();
        if (winner.getOutput() == 0.0) {
            return;
        }
        Layer mapLayer = this.neuralNetwork.getLayerAt(1);
        int winnerIdx = mapLayer.indexOf(winner);
        this.adjustCellWeights(winner, 0);
        int cellNum = mapLayer.getNeuronsCount();
        for (int p = 0; p < cellNum; ++p) {
            if (p == winnerIdx || !this.isNeighbor(winnerIdx, p, neighborhood)) continue;
            Neuron cell = mapLayer.getNeuronAt(p);
            this.adjustCellWeights(cell, 1);
        }
    }

    private Neuron getClosestNeuron() {
        Neuron winner = new Neuron();
        double minOutput = 100.0;
        for (Neuron n : this.neuralNetwork.getLayerAt(1).getNeurons()) {
            double out = n.getOutput();
            if (!(out < minOutput)) continue;
            minOutput = out;
            winner = n;
        }
        return winner;
    }

    private void adjustCellWeights(Neuron cell, int r) {
        for (Connection conn : cell.getInputConnections()) {
            double dWeight = this.learningRate / (double)(r + 1) * (conn.getInput() - conn.getWeight().getValue());
            conn.getWeight().inc(dWeight);
        }
    }

    private boolean isNeighbor(int i, int j, int n) {
        n = 1;
        int d = this.mapSize;
        int rt = n;
        while (i - rt * d < 0) {
            --rt;
        }
        int rb = n;
        while (i + rb * d > d * d - 1) {
            --rb;
        }
        for (int g = -rt; g <= rb; ++g) {
            int rl = n;
            int rlMod = (i - rl) % d;
            int i_mod = i % d;
            while (rlMod > i_mod) {
                rlMod = (i - --rl) % d;
            }
            int rd = n;
            int rdMod = (i + rd) % d;
            while (rdMod < i_mod) {
                rdMod = (i + --rd) % d;
            }
            if (j < i + g * d - rl || j > i + g * d + rd) continue;
            return true;
        }
        return false;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public void setIterations(int Iphase, int IIphase) {
        this.iterations[0] = Iphase;
        this.iterations[1] = IIphase;
    }

    public int getIteration() {
        return this.currentIteration;
    }

    public int getMapSize() {
        return this.mapSize;
    }

    @Override
    public void setNeuralNetwork(NeuralNetwork neuralNetwork) {
        super.setNeuralNetwork(neuralNetwork);
        int neuronsNum = neuralNetwork.getLayerAt(1).getNeuronsCount();
        this.mapSize = (int)Math.sqrt(neuronsNum);
    }
}

