/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.comp.layer;

import java.util.ArrayList;
import java.util.List;
import org.neuroph.core.Layer;
import org.neuroph.core.Neuron;
import org.neuroph.nnet.comp.Dimension2D;
import org.neuroph.nnet.comp.layer.FeatureMapLayer;
import org.neuroph.util.NeuronProperties;

public abstract class FeatureMapsLayer
extends Layer {
    private static final long serialVersionUID = -6706741997689639209L;
    protected Dimension2D mapDimensions;
    private List<FeatureMapLayer> featureMaps;

    public List<FeatureMapLayer> getFeatureMaps() {
        return this.featureMaps;
    }

    public FeatureMapsLayer() {
        this.featureMaps = new ArrayList<FeatureMapLayer>();
    }

    public FeatureMapsLayer(Dimension2D mapDimensions) {
        this.mapDimensions = mapDimensions;
        this.featureMaps = new ArrayList<FeatureMapLayer>();
    }

    public FeatureMapsLayer(Dimension2D kernelDimension, Dimension2D mapDimensions, int mapCount, NeuronProperties neuronProp) {
        this.mapDimensions = mapDimensions;
        this.featureMaps = new ArrayList<FeatureMapLayer>();
        this.createFeatureMaps(mapCount, mapDimensions, kernelDimension, neuronProp);
    }

    public FeatureMapsLayer(Dimension2D mapDimensions, int mapCount, NeuronProperties neuronProp) {
        this.mapDimensions = mapDimensions;
        this.featureMaps = new ArrayList<FeatureMapLayer>();
        this.createFeatureMaps(mapCount, mapDimensions, neuronProp);
    }

    public void addFeatureMap(FeatureMapLayer featureMap) {
        if (featureMap == null) {
            throw new IllegalArgumentException("FeatureMap cant be null!");
        }
        this.featureMaps.add(featureMap);
        this.neurons.addAll(featureMap.getNeurons());
    }

    protected final void createFeatureMaps(int mapCount, Dimension2D mapDimensions, Dimension2D kernelDimension, NeuronProperties neuronProperties) {
        for (int i = 0; i < mapCount; ++i) {
            this.addFeatureMap(new FeatureMapLayer(mapDimensions, neuronProperties, kernelDimension));
        }
    }

    private final void createFeatureMaps(int mapCount, Dimension2D mapDimensions, NeuronProperties neuronProperties) {
        for (int i = 0; i < mapCount; ++i) {
            this.addFeatureMap(new FeatureMapLayer(mapDimensions, neuronProperties));
        }
    }

    public FeatureMapLayer getFeatureMap(int index) {
        return this.featureMaps.get(index);
    }

    public int getNumberOfMaps() {
        return this.featureMaps.size();
    }

    public Neuron getNeuronAt(int x, int y, int mapIndex) {
        FeatureMapLayer map = this.featureMaps.get(mapIndex);
        return map.getNeuronAt(x, y);
    }

    @Override
    public int getNeuronsCount() {
        int neuronCount = 0;
        for (FeatureMapLayer map : this.featureMaps) {
            neuronCount += map.getNeuronsCount();
        }
        return neuronCount;
    }

    public Dimension2D getMapDimensions() {
        return this.mapDimensions;
    }

    public abstract void connectMaps(FeatureMapLayer var1, FeatureMapLayer var2);
}

