/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.image;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import org.neuroph.imgrec.image.Image;

public class ImageFactory {
    private static Image image;
    private static final String IMAGE_ANDROID_CLASS_NAME = "org.neuroph.imgrec.image.ImageAndroid";
    private static final String IMAGE_J2SE_CLASS_NAME = "org.neuroph.imgrec.image.ImageJ2SE";
    private static Class imageClass;
    private static Constructor constructor;

    public static Image createImage(Integer width, Integer height, Integer imageType) {
        try {
            constructor = imageClass.getDeclaredConstructor(Integer.class, Integer.class, Integer.class);
            constructor.setAccessible(true);
            image = (Image)constructor.newInstance(width, height, imageType);
        }
        catch (Exception e) {
            ImageFactory.handleException(e);
        }
        return image;
    }

    public static Image getImage(URL imageUrl) {
        try {
            constructor = imageClass.getDeclaredConstructor(URL.class);
            constructor.setAccessible(true);
            image = (Image)constructor.newInstance(imageUrl);
        }
        catch (Exception e) {
            ImageFactory.handleException(e);
        }
        return image;
    }

    public static Image getImage(File imageFile) {
        try {
            constructor = imageClass.getDeclaredConstructor(File.class);
            constructor.setAccessible(true);
            image = (Image)constructor.newInstance(imageFile);
        }
        catch (Exception e) {
            ImageFactory.handleException(e);
        }
        return image;
    }

    public static Image getImage(String filePath) {
        try {
            constructor = imageClass.getDeclaredConstructor(String.class);
            constructor.setAccessible(true);
            image = (Image)constructor.newInstance(filePath);
        }
        catch (Exception e) {
            ImageFactory.handleException(e);
        }
        return image;
    }

    private static void handleException(Exception e) {
        System.err.println(e.getMessage());
    }

    static {
        try {
            imageClass = System.getProperty("java.vendor").toLowerCase().indexOf("android") != -1 ? Class.forName(IMAGE_ANDROID_CLASS_NAME) : Class.forName(IMAGE_J2SE_CLASS_NAME);
        }
        catch (ClassNotFoundException cnf) {
            System.err.println(cnf.getMessage());
        }
    }
}

