/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.filter.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import org.neuroph.imgrec.filter.ImageFilter;

public class EdgeDetection
implements ImageFilter,
Serializable {
    int width;
    int height;
    transient BufferedImage originalImage;
    transient BufferedImage filteredImage;

    @Override
    public BufferedImage processImage(BufferedImage image) {
        this.originalImage = image;
        this.setAttributes(image);
        int width = this.originalImage.getWidth();
        int height = this.originalImage.getHeight();
        this.filteredImage = new BufferedImage(width, height, this.originalImage.getType());
        int[][] filter1 = new int[][]{{-1, 0, 1}, {-2, 0, 2}, {-1, 0, 1}};
        int[][] filter2 = new int[][]{{1, 2, 1}, {0, 0, 0}, {-1, -2, -1}};
        for (int y = 1; y < height - 1; ++y) {
            for (int x = 1; x < width - 1; ++x) {
                int[][] gray = new int[3][3];
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        gray[i][j] = (int)this.lum(new Color(this.originalImage.getRGB(x - 1 + i, y - 1 + j)));
                    }
                }
                int gray1 = 0;
                int gray2 = 0;
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        gray1 += gray[i][j] * filter1[i][j];
                        gray2 += gray[i][j] * filter2[i][j];
                    }
                }
                int magnitude = 255 - EdgeDetection.truncate((int)Math.sqrt(gray1 * gray1 + gray2 * gray2));
                Color grayscale = new Color(magnitude, magnitude, magnitude);
                this.filteredImage.setRGB(x, y, grayscale.getRGB());
            }
        }
        return this.filteredImage;
    }

    public static int truncate(int a) {
        if (a < 0) {
            return 0;
        }
        if (a > 255) {
            return 255;
        }
        return a;
    }

    private void setAttributes(BufferedImage image) {
        this.height = this.originalImage.getHeight();
        this.width = this.originalImage.getWidth();
    }

    public double lum(Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        return 0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b;
    }

    public String toString() {
        return "Edge Detection";
    }
}

