/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class ImageFilesIterator
implements Iterator<File> {
    private Iterator<File> imageIterator;
    private String currentFilename = null;

    public ImageFilesIterator(File dir) throws IOException {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir + " is not a directory!");
        }
        String[] imageFilenames = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name.length() > 4) {
                    String fileExtension = name.substring(name.length() - 4, name.length());
                    return ".jpg".equalsIgnoreCase(fileExtension) || ".png".equalsIgnoreCase(fileExtension);
                }
                return false;
            }
        });
        ArrayList<File> imageFiles = new ArrayList<File>();
        for (String imageFile : imageFilenames) {
            imageFiles.add(new File(dir, imageFile));
        }
        this.imageIterator = imageFiles.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.imageIterator.hasNext();
    }

    @Override
    public File next() {
        File nextFile = this.imageIterator.next();
        this.currentFilename = nextFile.getName();
        return nextFile;
    }

    @Override
    public void remove() {
        this.imageIterator.remove();
    }

    public String getFilenameOfCurrentImage() {
        return this.currentFilename;
    }
}

