/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.eval;

import java.util.ArrayList;
import java.util.List;
import org.neuroph.eval.EvaluationResult;
import org.neuroph.eval.classification.ClassificationMetrics;

public class CrossValidationResult {
    List<EvaluationResult> results = new ArrayList<EvaluationResult>();
    ClassificationMetrics.Stats average;
    int numberOfFolds;
    int numberOfInstances;

    public void addEvaluationResult(EvaluationResult result) {
        this.results.add(result);
    }

    public void calculateStatistics() {
        this.average = new ClassificationMetrics.Stats();
        double count = 0.0;
        ArrayList<String> classLabels = new ArrayList<String>();
        for (EvaluationResult er : this.results) {
            ClassificationMetrics[] ccm;
            for (ClassificationMetrics cm : ccm = er.getClassificationMetricses()) {
                this.average.accuracy += cm.getAccuracy();
                this.average.precision += cm.getPrecision();
                this.average.recall += cm.getRecall();
                this.average.fScore += cm.getFMeasure();
                this.average.mserror += er.getMeanSquareError();
                this.average.correlationCoefficient += cm.getMatthewsCorrelationCoefficient();
                if (classLabels.contains(cm.getClassLabel())) continue;
                classLabels.add(cm.getClassLabel());
            }
            count += 1.0;
        }
        this.average.accuracy /= (count *= (double)classLabels.size());
        this.average.precision /= count;
        this.average.recall /= count;
        this.average.fScore /= count;
        this.average.mserror /= count;
        this.average.correlationCoefficient /= count;
    }

    public ClassificationMetrics.Stats getAverages() {
        return this.average;
    }

    public String toString() {
        return "CrossValidationResult{results=" + this.results + ", average=" + this.average + '}';
    }

    public void printResult() {
        System.out.println("=== Cross validation result ===");
        System.out.println("Instances: " + this.numberOfInstances);
        System.out.println("Number of folds: " + this.numberOfFolds);
        System.out.println("\n");
        System.out.println("=== Summary ===");
        System.out.println("Mean squared error: " + this.average.mserror);
        System.out.println("Accuracy: " + this.average.accuracy);
        System.out.println("Precision: " + this.average.precision);
        System.out.println("Recall: " + this.average.recall);
        System.out.println("FScore: " + this.average.fScore);
        System.out.println("Correlation coefficient: " + this.average.correlationCoefficient);
    }
}

