/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib.model.sampling;

import java.util.ArrayList;
import java.util.List;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.data.DataSetRow;
import org.neuroph.util.data.sample.Sampling;

public abstract class AbstractSampling
implements Sampling {
    protected final int numberOfSamples;

    public AbstractSampling(int numberOfSamples) {
        this.numberOfSamples = numberOfSamples;
    }

    @Override
    public List<DataSet> sample(DataSet dataSet) {
        this.populateInternalDataStructure(dataSet);
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>(this.numberOfSamples);
        for (int i = 0; i < this.numberOfSamples; ++i) {
            dataSets.add(this.createDataSetFold(dataSet));
        }
        return dataSets;
    }

    private DataSet createDataSetFold(DataSet dataSet) {
        DataSet foldSet = new DataSet(dataSet.getInputSize(), dataSet.getOutputSize());
        for (int j = 0; j < this.getSampleSize(); ++j) {
            foldSet.addRow(this.getNextDataSetRow());
        }
        return foldSet;
    }

    protected abstract int getSampleSize();

    protected abstract DataSetRow getNextDataSetRow();

    protected abstract void populateInternalDataStructure(DataSet var1);
}

