/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.egads.utilities;

public class Variance {
    public int count = 0;
    public float sum = 0.0f;
    public float sumSquares = 0.0f;

    public void reset() {
        this.count = 0;
        this.sum = 0.0f;
        this.sumSquares = 0.0f;
    }

    public void increment(float value) {
        ++this.count;
        this.sum += value;
        this.sumSquares += value * value;
    }

    public float currentAverage() {
        return this.sum / (float)this.count;
    }

    public float currentVariance() {
        float mean = this.currentAverage();
        float sqMean = mean * mean;
        float meanOfSquares = this.sumSquares / (float)this.count;
        return meanOfSquares - sqMean;
    }

    public String toString() {
        return "" + this.currentVariance() + "=(" + this.sumSquares + "/" + this.count + ")-(" + this.sum + "/" + this.count + ")^2";
    }
}

