/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.egads.utilities;

import com.yahoo.egads.data.TimeSeries;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularValueDecomposition;

public class SpectralMethods {
    public static RealMatrix createHankelMatrix(RealMatrix data, int windowSize) {
        int n = data.getRowDimension();
        int m = data.getColumnDimension();
        int k = n - windowSize + 1;
        RealMatrix res = MatrixUtils.createRealMatrix((int)k, (int)(m * windowSize));
        double[] buffer = new double[]{};
        for (int i = 0; i < n; ++i) {
            double[] row = data.getRow(i);
            buffer = ArrayUtils.addAll((double[])buffer, (double[])row);
            if (i < windowSize - 1) continue;
            RealMatrix mat = MatrixUtils.createRowRealMatrix((double[])buffer);
            res.setRowMatrix(i - windowSize + 1, mat);
            buffer = ArrayUtils.subarray((double[])buffer, (int)m, (int)buffer.length);
        }
        return res;
    }

    public static RealMatrix averageHankelMatrix(RealMatrix hankelMat, int windowSize) {
        int k = hankelMat.getRowDimension();
        int m = hankelMat.getColumnDimension() / windowSize;
        int n = k + windowSize - 1;
        RealMatrix result = MatrixUtils.createRealMatrix((int)n, (int)m);
        for (int t = 0; t < n; ++t) {
            int h;
            int i = t < windowSize ? 0 : t - windowSize + 1;
            int j = t < windowSize ? t : windowSize - 1;
            int counter = 0;
            while (i < k && j >= 0) {
                for (h = 0; h < m; ++h) {
                    result.addToEntry(t, h, hankelMat.getEntry(i, j * m + h));
                }
                ++i;
                --j;
                ++counter;
            }
            for (h = 0; h < m; ++h) {
                result.setEntry(t, h, result.getEntry(t, h) / (double)counter);
            }
        }
        return result;
    }

    protected static double computeSmoothness(double[] variances) {
        double sum = 0.0;
        for (int i = 0; i < variances.length; ++i) {
            sum += variances[i];
        }
        double cumsum = 0.0;
        double sumcumsum = 0.0;
        for (int i = 0; i < variances.length; ++i) {
            sumcumsum += (cumsum += variances[i] / sum);
        }
        return 2.0 * sumcumsum / (double)variances.length - 1.0;
    }

    public static RealMatrix mFilter(RealMatrix data, int windowSize, FilteringMethod method, double methodParameter) {
        int n = data.getRowDimension();
        int m = data.getColumnDimension();
        int k = n - windowSize + 1;
        int i = 0;
        int ind = 0;
        double sum = 0.0;
        RealMatrix hankelMat = SpectralMethods.createHankelMatrix(data, windowSize);
        SingularValueDecomposition svd = new SingularValueDecomposition(hankelMat);
        double[] singularValues = svd.getSingularValues();
        block0 : switch (method) {
            case VARIANCE: {
                double[] temp = new double[singularValues.length - 1];
                for (i = 1; i < singularValues.length; ++i) {
                    sum += singularValues[i] * singularValues[i];
                }
                for (i = 0; i < temp.length; ++i) {
                    temp[i] = singularValues[i + 1] * singularValues[i + 1] / sum;
                }
                sum = 0.0;
                for (i = temp.length - 1; i >= 0; --i) {
                    if (!((sum += temp[i]) >= 1.0 - methodParameter)) continue;
                    ind = i;
                    break block0;
                }
                break;
            }
            case EXPLICIT: {
                ind = (int)Math.max(Math.min(methodParameter - 1.0, (double)(singularValues.length - 1)), 0.0);
                break;
            }
            case K_GAP: {
                final double[] eigenGaps = new double[singularValues.length - 1];
                Integer[] index = new Integer[singularValues.length - 1];
                for (i = 0; i < eigenGaps.length; ++i) {
                    eigenGaps[i] = singularValues[i] - singularValues[i + 1];
                    index[i] = i;
                }
                Arrays.sort(index, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer o1, Integer o2) {
                        return Double.compare(eigenGaps[o1], eigenGaps[o2]);
                    }
                });
                int maxIndex = 0;
                for (i = index.length - (int)methodParameter; i < index.length; ++i) {
                    if (index[i] <= maxIndex) continue;
                    maxIndex = index[i];
                }
                ind = Math.min(maxIndex, singularValues.length / 3);
                break;
            }
            case SMOOTHNESS: {
                double[] variances = new double[singularValues.length];
                for (i = 1; i < singularValues.length; ++i) {
                    variances[i] = singularValues[i] * singularValues[i];
                }
                variances[0] = variances[1];
                double smoothness = SpectralMethods.computeSmoothness(Arrays.copyOfRange(variances, 1, variances.length));
                if (methodParameter - smoothness < 0.01) {
                    methodParameter += 0.01;
                }
                double invalidS = smoothness;
                int validIndex = 1;
                int invalidIndex = singularValues.length;
                while (true) {
                    if (invalidS >= methodParameter) {
                        ind = invalidIndex - 1;
                        break block0;
                    }
                    if (invalidIndex - validIndex <= 1) {
                        ind = validIndex - 1;
                        break block0;
                    }
                    int ii = (validIndex + invalidIndex) / 2;
                    double[] tempVariances = Arrays.copyOf(Arrays.copyOfRange(variances, 0, ii + 1), singularValues.length);
                    double s = SpectralMethods.computeSmoothness(tempVariances);
                    if (s >= methodParameter) {
                        validIndex = ii;
                        continue;
                    }
                    invalidIndex = ii;
                    invalidS = s;
                }
            }
            case EIGEN_RATIO: {
                int startIndex = 0;
                int endIndex = singularValues.length - 1;
                if (singularValues[endIndex] / singularValues[0] >= methodParameter) {
                    ind = endIndex;
                    break;
                }
                while (true) {
                    int midIndex;
                    if (singularValues[midIndex = (startIndex + endIndex) / 2] / singularValues[0] >= methodParameter) {
                        if (singularValues[midIndex + 1] / singularValues[0] < methodParameter) {
                            ind = midIndex;
                            break block0;
                        }
                        startIndex = midIndex;
                        continue;
                    }
                    endIndex = midIndex;
                }
            }
            case GAP_RATIO: {
                double[] gaps = new double[singularValues.length - 1];
                for (i = 0; i < gaps.length; ++i) {
                    gaps[i] = singularValues[i] - singularValues[i + 1];
                }
                ind = 0;
                for (i = gaps.length - 1; i >= 0; --i) {
                    if (!(gaps[i] / singularValues[0] >= methodParameter)) continue;
                    ind = i;
                    break block0;
                }
                break;
            }
            default: {
                ind = singularValues.length - 1;
            }
        }
        ind = Math.max(0, Math.min(ind, singularValues.length - 1));
        RealMatrix truncatedHankelMatrix = MatrixUtils.createRealMatrix((int)k, (int)(m * windowSize));
        RealMatrix mU = svd.getU();
        RealMatrix mVT = svd.getVT();
        for (i = 0; i <= ind; ++i) {
            truncatedHankelMatrix = truncatedHankelMatrix.add(mU.getColumnMatrix(i).multiply(mVT.getRowMatrix(i)).scalarMultiply(singularValues[i]));
        }
        return SpectralMethods.averageHankelMatrix(truncatedHankelMatrix, windowSize);
    }

    public static TimeSeries.DataSequence mFilter(TimeSeries.DataSequence data, int windowSize, FilteringMethod method, double methodParameter) {
        TimeSeries.DataSequence result = new TimeSeries.DataSequence();
        RealMatrix dataMat = MatrixUtils.createRealMatrix((int)data.size(), (int)1);
        int i = 0;
        for (TimeSeries.Entry e : data) {
            dataMat.setEntry(i, 0, (double)e.value);
            ++i;
            TimeSeries.Entry eCopy = new TimeSeries.Entry(e);
            result.add(eCopy);
        }
        RealMatrix resultMat = SpectralMethods.mFilter(dataMat, windowSize, method, methodParameter);
        i = 0;
        for (TimeSeries.Entry e : result) {
            e.value = (float)resultMat.getEntry(i, 0);
            ++i;
        }
        return result;
    }

    public static enum FilteringMethod {
        K_GAP,
        VARIANCE,
        EXPLICIT,
        SMOOTHNESS,
        EIGEN_RATIO,
        GAP_RATIO;

    }
}

