/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.egads.utilities;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ListUtils {
    public static float sumQ(List<Float> Q) {
        float res = 0.0f;
        for (float f : Q) {
            res += f;
        }
        return res;
    }

    public static float sum2Q(List<Float> Q) {
        float res = 0.0f;
        for (float f : Q) {
            res += f * f;
        }
        return res;
    }

    public static void repQ(LinkedList<Float> Q, float value, int repitition) {
        Q.clear();
        for (int i = 0; i < repitition; ++i) {
            Q.addLast(Float.valueOf(value));
        }
    }

    public static float kernelSum(float x, List<Float> mean, List<Float> sds) {
        float res = 0.0f;
        float sd = 1.0f;
        Iterator<Float> it = sds.iterator();
        for (float m : mean) {
            if (it.hasNext()) {
                sd = it.next().floatValue();
            }
            res = (float)((double)res + Math.exp(-Math.pow(x - m, 2.0) / (2.0 * Math.pow(sd, 2.0))) / ((double)sd * Math.sqrt(Math.PI * 2)));
        }
        return res;
    }

    public static float kernelSubSum(float x, List<Float> mean, List<Float> sds, int from, int to) {
        float res = 0.0f;
        float sd = 1.0f;
        Iterator<Float> it = sds.iterator();
        int i = 0;
        for (float m : mean) {
            if (it.hasNext()) {
                sd = it.next().floatValue();
            }
            if (i >= from && i <= to) {
                res = (float)((double)res + Math.exp(-Math.pow(x - m, 2.0) / (2.0 * Math.pow(sd, 2.0))) / ((double)sd * Math.sqrt(Math.PI * 2)));
            }
            if (++i <= to) continue;
            break;
        }
        return res;
    }

    public static float sumLog(List<Float> Q) {
        float res = 0.0f;
        for (float f : Q) {
            res = (float)((double)res + Math.log(f));
        }
        return res;
    }

    public static LinkedList<Float> kernelQ(List<Float> Q, List<Float> mean, List<Float> sds) {
        LinkedList<Float> res = new LinkedList<Float>();
        float sd = 1.0f;
        float m = 0.0f;
        Iterator<Float> it1 = mean.iterator();
        Iterator<Float> it2 = sds.iterator();
        for (float x : Q) {
            if (it1.hasNext()) {
                m = it1.next().floatValue();
            }
            if (it2.hasNext()) {
                sd = it2.next().floatValue();
            }
            res.addLast(Float.valueOf((float)(Math.exp(-Math.pow(x - m, 2.0) / (2.0 * Math.pow(sd, 2.0))) / ((double)sd * Math.sqrt(Math.PI * 2)))));
        }
        return res;
    }

    public static void addQ(LinkedList<Float> Q, List<Float> P) {
        Iterator<Float> it = P.iterator();
        float p = 0.0f;
        LinkedList<Float> temp = new LinkedList<Float>();
        Iterator iterator = Q.iterator();
        while (iterator.hasNext()) {
            float q = ((Float)iterator.next()).floatValue();
            if (it.hasNext()) {
                p = it.next().floatValue();
            }
            temp.addLast(Float.valueOf(p + q));
        }
        Q.clear();
        Q.addAll(temp);
    }

    public static void subtractQ(LinkedList<Float> Q, List<Float> P) {
        Iterator<Float> it = P.iterator();
        float p = 0.0f;
        LinkedList<Float> temp = new LinkedList<Float>();
        Iterator iterator = Q.iterator();
        while (iterator.hasNext()) {
            float q = ((Float)iterator.next()).floatValue();
            if (it.hasNext()) {
                p = it.next().floatValue();
            }
            temp.addLast(Float.valueOf(q - p));
        }
        Q.clear();
        Q.addAll(temp);
    }

    public static void multiplyQ(LinkedList<Float> Q, List<Float> P) {
        Iterator<Float> it = P.iterator();
        float p = 0.0f;
        LinkedList<Float> temp = new LinkedList<Float>();
        Iterator iterator = Q.iterator();
        while (iterator.hasNext()) {
            float q = ((Float)iterator.next()).floatValue();
            if (it.hasNext()) {
                p = it.next().floatValue();
            }
            temp.addLast(Float.valueOf(q * p));
        }
        Q.clear();
        Q.addAll(temp);
    }

    public static LinkedList<Float> maxQ(List<Float> Q, float m) {
        LinkedList<Float> temp = new LinkedList<Float>();
        for (float q : Q) {
            temp.addLast(Float.valueOf(Math.max(q, m)));
        }
        return temp;
    }

    public static float quantile(List<Float> Q, float probability) {
        Collections.sort(Q);
        int n = Q.size();
        float index = (float)(n - 1) * probability;
        int lo = (int)Math.floor(index);
        int hi = (int)Math.ceil(index);
        float h = index - (float)lo;
        float qs = (1.0f - h) * Q.get(lo).floatValue() + h * Q.get(hi).floatValue();
        return qs;
    }
}

