/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.egads.utilities;

import com.yahoo.egads.data.Anomaly;
import com.yahoo.egads.data.AnomalyErrorStorage;
import com.yahoo.egads.data.TimeSeries;
import com.yahoo.egads.utilities.AutoSensitivity;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;

public class GUIUtils
extends ApplicationFrame {
    private static final long serialVersionUID = 1L;
    float maseDenom = 0.0f;
    private AnomalyErrorStorage aes = new AnomalyErrorStorage();
    private Properties config;

    private GUIUtils(String title, TimeSeries.DataSequence orig, TimeSeries.DataSequence predicted, ArrayList<Anomaly> anomalyList, Properties config) {
        super(title);
        this.config = config;
        JFreeChart chart = this.createCombinedChart(orig, predicted, anomalyList);
        ChartPanel panel = new ChartPanel(chart, true, true, true, false, true);
        panel.setPreferredSize(new Dimension(1440, 900));
        this.setContentPane((Container)panel);
    }

    private JFreeChart createCombinedChart(TimeSeries.DataSequence tsOne, TimeSeries.DataSequence tsTwo, ArrayList<Anomaly> anomalyList) {
        XYDataset data1 = this.createDataset(tsOne, "Original");
        StandardXYItemRenderer renderer1 = new StandardXYItemRenderer();
        NumberAxis rangeAxis1 = new NumberAxis("Original Value");
        XYPlot subplot1 = new XYPlot(data1, null, (ValueAxis)rangeAxis1, (XYItemRenderer)renderer1);
        subplot1.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        this.addAnomalies(subplot1, anomalyList);
        XYDataset data2 = this.createDataset(tsTwo, "Forecast");
        StandardXYItemRenderer renderer2 = new StandardXYItemRenderer();
        NumberAxis rangeAxis2 = new NumberAxis("Forecast Value");
        rangeAxis2.setAutoRangeIncludesZero(false);
        XYPlot subplot2 = new XYPlot(data2, null, (ValueAxis)rangeAxis2, (XYItemRenderer)renderer2);
        subplot2.setRangeAxisLocation(AxisLocation.TOP_OR_LEFT);
        CombinedDomainXYPlot plot = new CombinedDomainXYPlot((ValueAxis)new NumberAxis("Time"));
        plot.setGap(10.0);
        plot.add(subplot1, 1);
        plot.add(subplot2, 1);
        this.addAnomalyTS(plot, tsOne, tsTwo);
        plot.setOrientation(PlotOrientation.VERTICAL);
        return new JFreeChart("EGADS GUI", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
    }

    public void addAnomalyTS(CombinedDomainXYPlot plot, TimeSeries.DataSequence observedSeries, TimeSeries.DataSequence expectedSeries) {
        HashMap<String, ArrayList<Float>> allErrors = this.aes.initAnomalyErrors(observedSeries, expectedSeries);
        Float sDAutoSensitivity = Float.valueOf(0.0f);
        Float amntAutoSensitivity = Float.valueOf(0.0f);
        if (this.config.getProperty("AUTO_SENSITIVITY_ANOMALY_PCNT") != null) {
            amntAutoSensitivity = new Float(this.config.getProperty("AUTO_SENSITIVITY_ANOMALY_PCNT"));
        }
        if (this.config.getProperty("AUTO_SENSITIVITY_SD") != null) {
            sDAutoSensitivity = new Float(this.config.getProperty("AUTO_SENSITIVITY_SD"));
        }
        String errorDebug = "";
        for (int i = 0; i < this.aes.getIndexToError().keySet().size(); ++i) {
            Float[] fArray = allErrors.get(this.aes.getIndexToError().get(i)).toArray(new Float[allErrors.get(this.aes.getIndexToError().get(i)).size()]);
            XYDataset data1 = this.createDataset(fArray, this.aes.getIndexToError().get(i));
            StandardXYItemRenderer renderer1 = new StandardXYItemRenderer();
            NumberAxis rangeAxis1 = new NumberAxis(this.aes.getIndexToError().get(i));
            XYPlot subplot1 = new XYPlot(data1, null, (ValueAxis)rangeAxis1, (XYItemRenderer)renderer1);
            Float d = AutoSensitivity.getLowDensitySensitivity(fArray, sDAutoSensitivity.floatValue(), amntAutoSensitivity.floatValue());
            subplot1.addRangeMarker((Marker)new ValueMarker((double)d.floatValue()));
            subplot1.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
            plot.add(subplot1, 1);
            errorDebug = errorDebug + this.aes.getIndexToError().get(i) + ": " + d + " ";
        }
        System.out.println(errorDebug);
    }

    public void addAnomalies(XYPlot plot, ArrayList<Anomaly> anomalyList) {
        for (Anomaly a : anomalyList) {
            Anomaly.IntervalSequence is = a.intervals;
            for (Anomaly.Interval i : is) {
                ValueMarker marker = new ValueMarker((double)i.index.intValue());
                marker.setPaint((Paint)Color.black);
                plot.addDomainMarker((Marker)marker);
            }
        }
    }

    public XYDataset createDataset(Float[] ds, String label) {
        XYSeries observations = new XYSeries((Comparable)((Object)label));
        int n = ds.length;
        for (int i = 0; i < n; ++i) {
            observations.add((double)i, (Number)ds[i]);
        }
        XYSeriesCollection collection = new XYSeriesCollection();
        collection.addSeries(observations);
        return collection;
    }

    public XYDataset createDataset(TimeSeries.DataSequence ds, String label) {
        XYSeries observations = new XYSeries((Comparable)((Object)label));
        int n = ds.size();
        for (int i = 0; i < n; ++i) {
            observations.add((double)i, (double)((TimeSeries.Entry)ds.get((int)i)).value);
        }
        XYSeriesCollection collection = new XYSeriesCollection();
        collection.addSeries(observations);
        return collection;
    }

    public static void plotResults(TimeSeries.DataSequence orig, TimeSeries.DataSequence predicted, ArrayList<Anomaly> anomalyList, Properties config) {
        GUIUtils gui = new GUIUtils("EGADS GUI", orig, predicted, anomalyList, config);
        gui.pack();
        gui.setVisible(true);
        JFrame frame = new JFrame("EGADS GUI");
        JOptionPane.showMessageDialog(frame, "Click OK to continue");
        gui.setVisible(false);
    }
}

