/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.egads.utilities;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateTimeCalculator {
    private static Calendar cal = Calendar.getInstance();
    private static SimpleDateFormat[] formatters = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SS"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SS"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:S"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd")};
    private static SimpleDateFormat outputFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static Date getDate(String time) {
        Date date = null;
        for (int i = 0; i < formatters.length; ++i) {
            try {
                date = formatters[i].parse(time);
                break;
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        return date;
    }

    public static Date getDate(long timeInMilliSeconds) {
        cal.setTimeInMillis(timeInMilliSeconds);
        return cal.getTime();
    }

    public static long getMilliSeconds(String time) {
        Date date = DateTimeCalculator.getDate(time);
        cal.setTime(date);
        return cal.getTimeInMillis();
    }

    public static String format(String time) {
        return outputFormatter.format(DateTimeCalculator.getDate(time));
    }

    public static String format(long timeInMilliSeconds) {
        cal.setTimeInMillis(timeInMilliSeconds);
        return outputFormatter.format(cal.getTime());
    }

    public static String add(String time, int field, int amount) {
        Date date = DateTimeCalculator.getDate(time);
        cal.setTime(date);
        cal.add(field, amount);
        date = cal.getTime();
        return outputFormatter.format(date);
    }

    public static long add(long timeInMilliSeconds, int field, int amount) {
        cal.setTimeInMillis(timeInMilliSeconds);
        cal.add(field, amount);
        return cal.getTimeInMillis();
    }
}

