/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.egads.models.tsmm;

import com.yahoo.egads.data.TimeSeries;
import com.yahoo.egads.models.tsmm.TimeSeriesAbstractModel;
import java.util.Iterator;
import java.util.Properties;
import net.sourceforge.openforecast.DataPoint;
import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.ForecastingModel;
import net.sourceforge.openforecast.Observation;
import org.json.JSONObject;
import org.json.JSONStringer;

public class TripleExponentialSmoothingModel
extends TimeSeriesAbstractModel {
    private ForecastingModel forecaster;
    private TimeSeries.DataSequence data;

    public TripleExponentialSmoothingModel(Properties config) {
        super(config);
        this.modelName = "TripleExponentialSmoothingModel";
    }

    @Override
    public void reset() {
    }

    @Override
    public void train(TimeSeries.DataSequence data) {
        this.data = data;
        int n = data.size();
        Observation dp = null;
        DataSet observedData = new DataSet();
        for (int i = 0; i < n; ++i) {
            dp = new Observation(((TimeSeries.Entry)data.get((int)i)).value);
            dp.setIndependentValue("x", i);
            observedData.add(dp);
        }
        observedData.setTimeVariable("x");
        observedData.setPeriodsPerYear(12);
        this.forecaster = new net.sourceforge.openforecast.models.TripleExponentialSmoothingModel(0.75, 0.001, 0.001);
        this.forecaster.init(observedData);
        this.initForecastErrors(this.forecaster, data);
        logger.debug(this.getBias() + "\t" + this.getMAD() + "\t" + this.getMAPE() + "\t" + this.getMSE() + "\t" + this.getSAE() + "\t" + 0 + "\t" + 0);
    }

    @Override
    public void update(TimeSeries.DataSequence data) {
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public void predict(TimeSeries.DataSequence sequence) throws Exception {
        int n = this.data.size();
        DataSet requiredDataPoints = new DataSet();
        for (int count = 0; count < n; ++count) {
            Observation dp = new Observation(0.0);
            dp.setIndependentValue("x", count);
            requiredDataPoints.add(dp);
        }
        this.forecaster.forecast(requiredDataPoints);
        Iterator<DataPoint> it = requiredDataPoints.iterator();
        int i = 0;
        while (it.hasNext()) {
            DataPoint pnt = it.next();
            logger.info(((TimeSeries.Entry)this.data.get((int)i)).time + "," + ((TimeSeries.Entry)this.data.get((int)i)).value + "," + pnt.getDependentValue());
            sequence.set(i, new TimeSeries.Entry(((TimeSeries.Entry)this.data.get((int)i)).time, (float)pnt.getDependentValue()));
            ++i;
        }
    }

    @Override
    public void toJson(JSONStringer json_out) {
    }

    @Override
    public void fromJson(JSONObject json_obj) {
    }
}

