/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.egads.models.tsmm;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.yahoo.egads.data.TimeSeries;
import com.yahoo.egads.data.WeightedValue;
import com.yahoo.egads.models.tsmm.TimeSeriesAbstractModel;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.math3.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlympicModel2
extends TimeSeriesAbstractModel {
    private static final Logger LOG = LoggerFactory.getLogger(OlympicModel2.class);
    private static final long serialVersionUID = 4322074416636265537L;
    protected final long windowSize;
    protected final ChronoUnit windowUnits;
    protected final long interval;
    protected final ChronoUnit intervalUnits;
    protected final long windowDistanceInterval;
    protected final ChronoUnit windowDistanceIntervalUnits;
    protected final String windowAggregator;
    protected final int futureWindows;
    protected final int pastWindows;
    protected final long modelStartEpoch;
    protected final ZoneId zone;
    protected final boolean weighting;
    protected final int drop_highest;
    protected final int drop_lowest;
    protected final List<Pair<Long, Double>> model;
    protected final ZonedDateTime[] windowTimes;
    protected final int[] indices;

    public OlympicModel2(Properties config) {
        super(config);
        String temp = config.getProperty("WINDOW_SIZE");
        if (temp == null || temp.isEmpty()) {
            throw new IllegalArgumentException("WINDOW_SIZE is required, e.g. 1 or 5");
        }
        this.windowSize = Long.parseLong(temp);
        temp = config.getProperty("WINDOW_SIZE_UNITS");
        if (temp == null || temp.isEmpty()) {
            throw new IllegalArgumentException("WINDOW_SIZE_UNITS is required, e.g. MINUTES OR HOURS");
        }
        this.windowUnits = ChronoUnit.valueOf(temp.toUpperCase());
        temp = config.getProperty("INTERVAL");
        if (temp == null || temp.isEmpty()) {
            throw new IllegalArgumentException("INTERVAL is required, e.g. 1 or 5");
        }
        this.interval = Long.parseLong(temp);
        temp = config.getProperty("INTERVAL_UNITS");
        if (temp == null || temp.isEmpty()) {
            throw new IllegalArgumentException("INTERVAL_UNITS is required, e.g. MINUTES OR HOURS");
        }
        this.intervalUnits = ChronoUnit.valueOf(temp.toUpperCase());
        temp = config.getProperty("WINDOW_DISTANCE");
        if (temp == null || temp.isEmpty()) {
            throw new IllegalArgumentException("WINDOW_DISTANCE is required, e.g. 1 or 5");
        }
        this.windowDistanceInterval = Long.parseLong(temp);
        temp = config.getProperty("WINDOW_DISTANCE_UNITS");
        if (temp == null || temp.isEmpty()) {
            throw new IllegalArgumentException("WINDOW_DISTANCE_UNITS is required, e.g. MINUTES OR HOURS");
        }
        this.windowDistanceIntervalUnits = ChronoUnit.valueOf(temp.toUpperCase());
        temp = config.getProperty("WINDOW_AGGREGATOR");
        if (temp == null || temp.isEmpty()) {
            this.windowAggregator = "AVG";
        } else {
            if (!((temp = temp.toUpperCase()).equals("AVG") || temp.equals("MIN") || temp.equals("MAX") || temp.equals("SUM") || temp.equals("COUNT") || temp.equals("WAVG") || temp.equals("MEDIAN"))) {
                throw new IllegalArgumentException("The window aggregator was not implemented: " + temp);
            }
            this.windowAggregator = temp;
        }
        temp = config.getProperty("MODEL_START");
        if (temp == null || temp.isEmpty()) {
            throw new IllegalArgumentException("MODEL_START is required, e.g. 1474756200");
        }
        this.modelStartEpoch = Long.parseLong(temp);
        this.pastWindows = Integer.parseInt(config.getProperty("HISTORICAL_WINDOWS", "1"));
        this.weighting = Boolean.parseBoolean(config.getProperty("ENABLE_WEIGHTING", "false"));
        this.futureWindows = Integer.parseInt(config.getProperty("FUTURE_WINDOWS", "1"));
        this.drop_highest = Integer.parseInt(config.getProperty("NUM_TO_DROP_HIGHEST", "0"));
        this.drop_lowest = Integer.parseInt(config.getProperty("NUM_TO_DROP_LOWEST", "0"));
        this.zone = ZoneId.of(config.getProperty("TIMEZONE", "UTC"));
        this.windowTimes = new ZonedDateTime[this.pastWindows];
        this.indices = new int[this.pastWindows];
        this.model = Lists.newArrayList();
    }

    @Override
    public void train(TimeSeries.DataSequence data) throws Exception {
        this.initializeIndices(data, this.modelStartEpoch);
        long size = data.size();
        ZonedDateTime model_ts = Instant.ofEpochSecond(this.modelStartEpoch).atZone(this.zone);
        ZonedDateTime end_ts = model_ts.plus(this.windowSize, this.windowUnits);
        int prediction_index = 0;
        ArrayList accumulator = Lists.newArrayList();
        while (true) {
            int i;
            accumulator.clear();
            for (i = 0; i < this.windowTimes.length; ++i) {
                if (this.indices[i] < 0 || (long)this.indices[i] >= size) continue;
                this.windowTimes[i] = this.windowTimes[i].plus(this.interval, this.intervalUnits);
                long interval_end = this.windowTimes[i].toEpochSecond();
                ArrayList doubles = Lists.newArrayList();
                long first_ts = -1L;
                while ((long)this.indices[i] < size && ((TimeSeries.Entry)data.get((int)this.indices[i])).time < interval_end) {
                    if (Double.isFinite(((TimeSeries.Entry)data.get((int)this.indices[i])).value)) {
                        doubles.add(Double.valueOf(((TimeSeries.Entry)data.get((int)this.indices[i])).value));
                    }
                    if (first_ts < 0L) {
                        first_ts = ((TimeSeries.Entry)data.get((int)this.indices[i])).time;
                    }
                    int n = i;
                    this.indices[n] = this.indices[n] + 1;
                }
                if (doubles.isEmpty()) continue;
                double sum = 0.0;
                for (Double v : doubles) {
                    sum += v.doubleValue();
                }
                accumulator.add(new WeightedValue(sum / (double)doubles.size(), i + 1));
            }
            if (this.drop_lowest > 0 || this.drop_highest > 0) {
                if (this.drop_highest > this.drop_lowest) {
                    WeightedValue.drop(accumulator, this.drop_highest, true);
                    WeightedValue.drop(accumulator, this.drop_lowest, false);
                } else {
                    WeightedValue.drop(accumulator, this.drop_lowest, false);
                    WeightedValue.drop(accumulator, this.drop_highest, true);
                }
            }
            this.model.add((Pair<Long, Double>)new Pair((Object)model_ts.toEpochSecond(), (Object)WeightedValue.aggregate(accumulator, this.windowAggregator)));
            if ((model_ts = model_ts.plus(this.interval, this.intervalUnits)).toEpochSecond() <= end_ts.toEpochSecond()) continue;
            if (++prediction_index >= this.futureWindows) break;
            model_ts = Instant.ofEpochSecond(this.modelStartEpoch).atZone(this.zone);
            model_ts = model_ts.plus(this.windowDistanceInterval * (long)prediction_index, this.windowDistanceIntervalUnits);
            end_ts = model_ts.plus(this.windowSize, this.windowUnits);
            for (i = 0; i < this.windowTimes.length; ++i) {
                this.windowTimes[i] = null;
                this.indices[i] = 0;
            }
            this.initializeIndices(data, model_ts.toEpochSecond());
        }
    }

    @Override
    public void update(TimeSeries.DataSequence data) throws Exception {
        throw new NotImplementedException();
    }

    @Override
    public void predict(TimeSeries.DataSequence sequence) throws Exception {
        if (this.model == null || this.model.isEmpty()) {
            throw new IllegalStateException("Model was empty. 'train()' may not have been called.");
        }
        int x = 0;
        for (int i = 0; i < sequence.size(); ++i) {
            while (x < this.model.size() && ((TimeSeries.Entry)sequence.get((int)i)).time > (Long)this.model.get(x).getKey()) {
                ++x;
            }
            if (x >= this.model.size()) break;
            if (((TimeSeries.Entry)sequence.get((int)i)).time != (Long)this.model.get(x).getKey()) continue;
            Pair<Long, Double> dp = this.model.get(x++);
            sequence.set(i, new TimeSeries.Entry((Long)dp.getKey(), (float)((Double)dp.getValue()).doubleValue()));
        }
    }

    @Override
    public void reset() {
        this.model.clear();
        for (int i = 0; i < this.windowTimes.length; ++i) {
            this.windowTimes[i] = null;
            this.indices[i] = 0;
        }
    }

    @VisibleForTesting
    void initializeIndices(TimeSeries.DataSequence data, long start) {
        if (data == null || data.size() < 1) {
            throw new IllegalArgumentException("DataSequence cannot be null or empty.");
        }
        ZonedDateTime base = Instant.ofEpochSecond(start).atZone(this.zone);
        for (int i = 0; i < this.pastWindows; ++i) {
            ZonedDateTime seek = base.minus(this.windowDistanceInterval * (long)(this.pastWindows - i), this.windowDistanceIntervalUnits);
            long seek_time = seek.toEpochSecond();
            int idx = data.size() / (this.pastWindows - i);
            if (idx >= data.size()) {
                idx = data.size() - 1;
            }
            if (((TimeSeries.Entry)data.get((int)idx)).time != seek_time) {
                if (((TimeSeries.Entry)data.get((int)idx)).time < seek_time) {
                    while (idx < data.size() && ((TimeSeries.Entry)data.get((int)idx)).time < seek_time) {
                        ++idx;
                    }
                } else {
                    while (idx > 0 && ((TimeSeries.Entry)data.get((int)(idx - 1))).time >= seek_time) {
                        --idx;
                    }
                }
            }
            if (idx >= data.size()) {
                idx = -1;
            }
            this.windowTimes[i] = seek;
            this.indices[i] = idx;
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Initializing index: " + i + " to " + idx + " at " + seek);
        }
    }
}

