/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.egads.data;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WeightedValue
implements Comparable<WeightedValue> {
    private final double value;
    private final int weight;

    public WeightedValue(double value, int weight) {
        this.value = value;
        this.weight = weight;
    }

    @Override
    public int compareTo(WeightedValue other) {
        return Double.compare(this.value, other.value);
    }

    public static void drop(List<WeightedValue> accumulator, int count, boolean highest) {
        for (int x = 0; x < count && accumulator.size() > 1; ++x) {
            if (highest) {
                accumulator.remove(Collections.max(accumulator));
                continue;
            }
            accumulator.remove(Collections.min(accumulator));
        }
    }

    public double getValue() {
        return this.value;
    }

    public int getWeight() {
        return this.weight;
    }

    public static double aggregate(List<WeightedValue> values, String agg) {
        if (agg == null || agg.isEmpty()) {
            throw new IllegalArgumentException("Aggregator cannot be null or empty");
        }
        if (values == null) {
            throw new IllegalArgumentException("Values cannot be null");
        }
        if (values.isEmpty()) {
            if (agg.equals("COUNT")) {
                return 0.0;
            }
            return Double.NaN;
        }
        int validCount = 0;
        double accumulator = 0.0;
        if (agg.equals("MAX")) {
            accumulator = Double.MIN_VALUE;
            for (WeightedValue v : values) {
                if (!Double.isFinite(v.value)) continue;
                if (v.value > accumulator) {
                    accumulator = v.value;
                }
                ++validCount;
            }
            if (validCount < 1) {
                return Double.NaN;
            }
            return accumulator;
        }
        if (agg.equals("MIN")) {
            accumulator = Double.MAX_VALUE;
            for (WeightedValue v : values) {
                if (!Double.isFinite(v.value)) continue;
                if (v.value < accumulator) {
                    accumulator = v.value;
                }
                ++validCount;
            }
            if (validCount < 1) {
                return Double.NaN;
            }
            return accumulator;
        }
        if (agg.equals("COUNT")) {
            int ctr = 0;
            for (WeightedValue v : values) {
                if (!Double.isFinite(v.value)) continue;
                ++ctr;
            }
            return ctr;
        }
        if (agg.equals("MEDIAN")) {
            ArrayList sorted = Lists.newArrayList();
            for (WeightedValue v : values) {
                if (!Double.isFinite(v.value)) continue;
                sorted.add(v.value);
                ++validCount;
            }
            if (validCount < 1) {
                return Double.NaN;
            }
            Collections.sort(sorted);
            return (Double)sorted.get(sorted.size() / 2);
        }
        if (agg.equals("SUM")) {
            for (WeightedValue v : values) {
                if (!Double.isFinite(v.value)) continue;
                accumulator += v.value;
                ++validCount;
            }
            if (validCount < 1) {
                return Double.NaN;
            }
            return accumulator;
        }
        if (agg.equals("AVG")) {
            for (WeightedValue v : values) {
                if (!Double.isFinite(v.value)) continue;
                accumulator += v.value;
                ++validCount;
            }
            if (validCount < 1) {
                return Double.NaN;
            }
            return accumulator / (double)validCount;
        }
        if (agg.equals("WAVG")) {
            for (WeightedValue v : values) {
                if (!Double.isFinite(v.value)) continue;
                accumulator += (double)v.weight * v.value;
                validCount += v.weight;
            }
            if (validCount < 1) {
                return Double.NaN;
            }
            return accumulator / (double)validCount;
        }
        throw new IllegalArgumentException("Unimplemented aggregation function: " + agg);
    }
}

