/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.egads.data;

import com.yahoo.egads.data.TimeSeries;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AnomalyErrorStorage {
    protected float maseDenom;
    protected Map<String, Integer> errorToIndex = new HashMap<String, Integer>();
    protected Map<Integer, String> indexToError;
    boolean isInit = false;

    public Map<String, Integer> getErrorToIndex() {
        return this.errorToIndex;
    }

    public Map<Integer, String> getIndexToError() {
        return this.indexToError;
    }

    public AnomalyErrorStorage() {
        this.errorToIndex.put("mapee", 0);
        this.errorToIndex.put("mae", 1);
        this.errorToIndex.put("smape", 2);
        this.errorToIndex.put("mape", 3);
        this.errorToIndex.put("mase", 4);
        this.indexToError = new HashMap<Integer, String>();
        this.indexToError.put(0, "mapee");
        this.indexToError.put(1, "mae");
        this.indexToError.put(2, "smape");
        this.indexToError.put(3, "mape");
        this.indexToError.put(4, "mase");
    }

    public HashMap<String, ArrayList<Float>> initAnomalyErrors(TimeSeries.DataSequence observedSeries, TimeSeries.DataSequence expectedSeries) {
        int n = observedSeries.size();
        for (int i = 1; i < n; ++i) {
            this.maseDenom += Math.abs(((TimeSeries.Entry)observedSeries.get((int)i)).value - ((TimeSeries.Entry)observedSeries.get((int)(i - 1))).value);
        }
        this.maseDenom /= (float)(n - 1);
        HashMap<String, ArrayList<Float>> allErrors = new HashMap<String, ArrayList<Float>>();
        for (int i = 0; i < n; ++i) {
            Float[] errors = this.computeErrorMetrics(((TimeSeries.Entry)expectedSeries.get((int)i)).value, ((TimeSeries.Entry)observedSeries.get((int)i)).value);
            for (int j = 0; j < errors.length; ++j) {
                if (!allErrors.containsKey(this.indexToError.get(j))) {
                    allErrors.put(this.indexToError.get(j), new ArrayList());
                }
                ArrayList<Float> tmp = allErrors.get(this.indexToError.get(j));
                tmp.add(errors[j]);
                allErrors.put(this.indexToError.get(j), tmp);
            }
        }
        this.isInit = true;
        return allErrors;
    }

    public Float[] computeErrorMetrics(float expected, float actual) {
        float div = expected;
        if (expected == 0.0f) {
            div = 1.0E-10f;
        }
        float mae = Math.abs(actual - expected);
        float smape = 200.0f * Math.abs(actual - expected) / (Math.abs(actual) + Math.abs(expected) == 0.0f ? 1.0f : Math.abs(actual) + Math.abs(expected));
        float mape = Math.abs(actual) == 0.0f ? 0.0f : 100.0f * Math.abs(actual - expected) / Math.abs(actual);
        float mase = (double)Math.abs(this.maseDenom) == 0.0 ? 0.0f : Math.abs(actual - expected) / Math.abs(this.maseDenom);
        float mapee = expected == actual ? 0.0f : Math.abs(100.0f * (actual / div - 1.0f));
        Float[] errors = new Float[]{Float.valueOf(mapee), Float.valueOf(mae), Float.valueOf(smape), Float.valueOf(mape), Float.valueOf(mase)};
        return errors;
    }
}

