/*
 * Decompiled with CFR 0.152.
 */
package com.github.servicenow.ds.stats;

public class TimeSeriesUtilities {
    public static double[] simpleMovingAverage(double[] data, int window) {
        double[] average = new double[data.length - window + 1];
        TimeSeriesUtilities.simpleMovingAverage(data, window, average);
        return average;
    }

    public static void simpleMovingAverage(double[] data, int window, double[] average) {
        if (average.length < data.length - window + 1) {
            throw new IllegalArgumentException("simpleMovingAverage: insufficient memory to store moving average");
        }
        double windowSum = 0.0;
        for (int i = 0; i < window; ++i) {
            windowSum += data[i];
        }
        average[0] = windowSum / (double)window;
        int windowEnd = window;
        int windowStart = 0;
        for (int j = 1; j < data.length - window + 1; ++j) {
            average[j] = (windowSum += data[++windowEnd] - data[++windowStart]) / (double)window;
        }
    }
}

