/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import org.ejml.UtilEjml;
import org.ejml.data.DenseMatrix64F;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.ops.CommonOps;
import org.ejml.ops.SpecializedOps;

public class SingularOps {
    public static void descendingOrder(DenseMatrix64F denseMatrix64F, boolean bl, DenseMatrix64F denseMatrix64F2, DenseMatrix64F denseMatrix64F3, boolean bl2) {
        int n = Math.min(denseMatrix64F2.numRows, denseMatrix64F2.numCols);
        SingularOps.checkSvdMatrixSize(denseMatrix64F, bl, denseMatrix64F2, denseMatrix64F3, bl2);
        for (int i = 0; i < n; ++i) {
            double d = -1.0;
            int n2 = -1;
            for (int j = i; j < n; ++j) {
                double d2 = denseMatrix64F2.get(j, j);
                if (!(d2 > d)) continue;
                d = d2;
                n2 = j;
            }
            if (n2 == i) continue;
            if (n2 == -1) break;
            double d3 = denseMatrix64F2.get(i, i);
            denseMatrix64F2.set(i, i, d);
            denseMatrix64F2.set(n2, n2, d3);
            if (denseMatrix64F3 != null) {
                SingularOps.swapRowOrCol(denseMatrix64F3, bl2, i, n2);
            }
            if (denseMatrix64F == null) continue;
            SingularOps.swapRowOrCol(denseMatrix64F, bl, i, n2);
        }
    }

    public static void descendingOrder(DenseMatrix64F denseMatrix64F, boolean bl, double[] dArray, int n, DenseMatrix64F denseMatrix64F2, boolean bl2) {
        for (int i = 0; i < n; ++i) {
            double d = -1.0;
            int n2 = -1;
            for (int j = i; j < n; ++j) {
                double d2 = dArray[j];
                if (!(d2 > d)) continue;
                d = d2;
                n2 = j;
            }
            if (n2 == i) continue;
            if (n2 == -1) break;
            double d3 = dArray[i];
            dArray[i] = d;
            dArray[n2] = d3;
            if (denseMatrix64F2 != null) {
                SingularOps.swapRowOrCol(denseMatrix64F2, bl2, i, n2);
            }
            if (denseMatrix64F == null) continue;
            SingularOps.swapRowOrCol(denseMatrix64F, bl, i, n2);
        }
    }

    public static void checkSvdMatrixSize(DenseMatrix64F denseMatrix64F, boolean bl, DenseMatrix64F denseMatrix64F2, DenseMatrix64F denseMatrix64F3, boolean bl2) {
        boolean bl3;
        int n = Math.min(denseMatrix64F2.numRows, denseMatrix64F2.numCols);
        boolean bl4 = bl3 = denseMatrix64F2.numRows == denseMatrix64F2.numCols;
        if (bl3) {
            if (denseMatrix64F != null) {
                if (bl && denseMatrix64F.numRows != n) {
                    throw new IllegalArgumentException("Unexpected size of matrix U");
                }
                if (!bl && denseMatrix64F.numCols != n) {
                    throw new IllegalArgumentException("Unexpected size of matrix U");
                }
            }
            if (denseMatrix64F3 != null) {
                if (bl2 && denseMatrix64F3.numRows != n) {
                    throw new IllegalArgumentException("Unexpected size of matrix V");
                }
                if (!bl2 && denseMatrix64F3.numCols != n) {
                    throw new IllegalArgumentException("Unexpected size of matrix V");
                }
            }
        } else {
            if (denseMatrix64F != null && denseMatrix64F.numRows != denseMatrix64F.numCols) {
                throw new IllegalArgumentException("Unexpected size of matrix U");
            }
            if (denseMatrix64F3 != null && denseMatrix64F3.numRows != denseMatrix64F3.numCols) {
                throw new IllegalArgumentException("Unexpected size of matrix V");
            }
            if (denseMatrix64F != null && denseMatrix64F.numRows != denseMatrix64F2.numRows) {
                throw new IllegalArgumentException("Unexpected size of W");
            }
            if (denseMatrix64F3 != null && denseMatrix64F3.numRows != denseMatrix64F2.numCols) {
                throw new IllegalArgumentException("Unexpected size of W");
            }
        }
    }

    private static void swapRowOrCol(DenseMatrix64F denseMatrix64F, boolean bl, int n, int n2) {
        if (bl) {
            for (int i = 0; i < denseMatrix64F.numCols; ++i) {
                double d = denseMatrix64F.get(n, i);
                denseMatrix64F.set(n, i, denseMatrix64F.get(n2, i));
                denseMatrix64F.set(n2, i, d);
            }
        } else {
            for (int i = 0; i < denseMatrix64F.numRows; ++i) {
                double d = denseMatrix64F.get(i, n);
                denseMatrix64F.set(i, n, denseMatrix64F.get(i, n2));
                denseMatrix64F.set(i, n2, d);
            }
        }
    }

    public static DenseMatrix64F nullSpace(SingularValueDecomposition<DenseMatrix64F> singularValueDecomposition, DenseMatrix64F denseMatrix64F, double d) {
        int n;
        int n2;
        int n3 = singularValueDecomposition.numberOfSingularValues();
        double[] dArray = singularValueDecomposition.getSingularValues();
        DenseMatrix64F denseMatrix64F2 = singularValueDecomposition.getV(null, true);
        if (denseMatrix64F2.numRows != singularValueDecomposition.numCols()) {
            throw new IllegalArgumentException("Can't compute the null space using a compact SVD for a matrix of this size.");
        }
        int n4 = singularValueDecomposition.numCols() - n3;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!(dArray[n2] <= d)) continue;
            ++n4;
        }
        if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(n4, singularValueDecomposition.numCols());
        } else {
            denseMatrix64F.reshape(n4, singularValueDecomposition.numCols());
        }
        n2 = 0;
        for (n = 0; n < n3; ++n) {
            if (!(dArray[n] <= d)) continue;
            CommonOps.extract(denseMatrix64F2, n, n + 1, 0, denseMatrix64F2.numCols, denseMatrix64F, n2++, 0);
        }
        for (n = n3; n < singularValueDecomposition.numCols(); ++n) {
            CommonOps.extract(denseMatrix64F2, n, n + 1, 0, denseMatrix64F2.numCols, denseMatrix64F, n2++, 0);
        }
        CommonOps.transpose(denseMatrix64F);
        return denseMatrix64F;
    }

    public static DenseMatrix64F nullVector(SingularValueDecomposition<DenseMatrix64F> singularValueDecomposition, boolean bl, DenseMatrix64F denseMatrix64F) {
        DenseMatrix64F denseMatrix64F2;
        int n = singularValueDecomposition.numberOfSingularValues();
        double[] dArray = singularValueDecomposition.getSingularValues();
        DenseMatrix64F denseMatrix64F3 = denseMatrix64F2 = bl ? (DenseMatrix64F)singularValueDecomposition.getV(null, true) : (DenseMatrix64F)singularValueDecomposition.getU(null, false);
        if (bl) {
            if (denseMatrix64F2.numRows != singularValueDecomposition.numCols()) {
                throw new IllegalArgumentException("Can't compute the null space using a compact SVD for a matrix of this size.");
            }
            if (denseMatrix64F == null) {
                denseMatrix64F = new DenseMatrix64F(singularValueDecomposition.numCols(), 1);
            }
        } else {
            if (denseMatrix64F2.numCols != singularValueDecomposition.numRows()) {
                throw new IllegalArgumentException("Can't compute the null space using a compact SVD for a matrix of this size.");
            }
            if (denseMatrix64F == null) {
                denseMatrix64F = new DenseMatrix64F(singularValueDecomposition.numRows(), 1);
            }
        }
        int n2 = -1;
        if (bl && singularValueDecomposition.numCols() > singularValueDecomposition.numRows()) {
            n2 = singularValueDecomposition.numCols() - 1;
        } else if (!bl && singularValueDecomposition.numCols() < singularValueDecomposition.numRows()) {
            n2 = singularValueDecomposition.numRows() - 1;
        } else {
            double d = Double.MAX_VALUE;
            for (int i = 0; i < n; ++i) {
                if (!(dArray[i] < d)) continue;
                d = dArray[i];
                n2 = i;
            }
        }
        if (bl) {
            SpecializedOps.subvector(denseMatrix64F2, n2, 0, denseMatrix64F2.numRows, true, 0, denseMatrix64F);
        } else {
            SpecializedOps.subvector(denseMatrix64F2, 0, n2, denseMatrix64F2.numRows, false, 0, denseMatrix64F);
        }
        return denseMatrix64F;
    }

    public static double singularThreshold(SingularValueDecomposition singularValueDecomposition) {
        int n;
        double d = 0.0;
        double[] dArray = singularValueDecomposition.getSingularValues();
        int n2 = singularValueDecomposition.numberOfSingularValues();
        for (n = 0; n < n2; ++n) {
            if (!(dArray[n] > d)) continue;
            d = dArray[n];
        }
        n = Math.max(singularValueDecomposition.numCols(), singularValueDecomposition.numRows());
        return (double)n * d * UtilEjml.EPS;
    }

    public static int rank(SingularValueDecomposition singularValueDecomposition) {
        double d = SingularOps.singularThreshold(singularValueDecomposition);
        return SingularOps.rank(singularValueDecomposition, d);
    }

    public static int rank(SingularValueDecomposition singularValueDecomposition, double d) {
        int n = 0;
        double[] dArray = singularValueDecomposition.getSingularValues();
        int n2 = singularValueDecomposition.numberOfSingularValues();
        for (int i = 0; i < n2; ++i) {
            if (!(dArray[i] > d)) continue;
            ++n;
        }
        return n;
    }

    public static int nullity(SingularValueDecomposition singularValueDecomposition) {
        double d = SingularOps.singularThreshold(singularValueDecomposition);
        return SingularOps.nullity(singularValueDecomposition, d);
    }

    public static int nullity(SingularValueDecomposition singularValueDecomposition, double d) {
        int n = 0;
        double[] dArray = singularValueDecomposition.getSingularValues();
        int n2 = singularValueDecomposition.numberOfSingularValues();
        int n3 = singularValueDecomposition.numCols();
        for (int i = 0; i < n2; ++i) {
            if (!(dArray[i] <= d)) continue;
            ++n;
        }
        return n + n3 - n2;
    }
}

