/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.equation;

import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DenseMatrix64F;
import org.ejml.equation.ManagerTempVariables;
import org.ejml.equation.Variable;
import org.ejml.equation.VariableMatrix;
import org.ejml.equation.VariableScalar;
import org.ejml.ops.CommonOps;

public class MatrixConstructor {
    VariableMatrix output;
    List<Item> items = new ArrayList<Item>();
    List<VariableScalar> tmp = new ArrayList<VariableScalar>();

    public MatrixConstructor(ManagerTempVariables managerTempVariables) {
        this.output = managerTempVariables.createMatrix();
    }

    public void addToRow(Variable variable) {
        this.items.add(new Item(variable));
    }

    public void endRow() {
        this.items.add(new Item());
    }

    public void construct() {
        if (!this.items.get((int)(this.items.size() - 1)).endRow) {
            this.endRow();
        }
        this.setToRequiredSize(this.output.matrix);
        int n = 0;
        ArrayList<Item> arrayList = new ArrayList<Item>();
        for (int i = 0; i < this.items.size(); ++i) {
            Item item = this.items.get(i);
            if (item.endRow) {
                Item item2 = (Item)arrayList.get(0);
                int n2 = item2.getRows();
                int n3 = item2.getColumns();
                if (item2.matrix) {
                    CommonOps.insert(item2.getMatrix(), this.output.matrix, n, 0);
                } else {
                    this.output.matrix.set(n, 0, item2.getValue());
                }
                for (int j = 1; j < arrayList.size(); ++j) {
                    item2 = (Item)arrayList.get(j);
                    if (item2.getRows() != n2) {
                        throw new RuntimeException("Row miss-matched. " + n2 + " " + item2.getRows());
                    }
                    if (item2.matrix) {
                        CommonOps.insert(item2.getMatrix(), this.output.matrix, n, n3);
                    } else {
                        this.output.matrix.set(n, n3, item2.getValue());
                    }
                    n3 += item2.getColumns();
                }
                n += n2;
                arrayList.clear();
                continue;
            }
            arrayList.add(item);
        }
    }

    public VariableMatrix getOutput() {
        return this.output;
    }

    protected void setToRequiredSize(DenseMatrix64F denseMatrix64F) {
        int n = 0;
        int n2 = 0;
        ArrayList<Item> arrayList = new ArrayList<Item>();
        for (int i = 0; i < this.items.size(); ++i) {
            Item item = this.items.get(i);
            if (item.endRow) {
                Item item2 = (Item)arrayList.get(0);
                int n3 = item2.getRows();
                int n4 = item2.getColumns();
                for (int j = 1; j < arrayList.size(); ++j) {
                    item2 = (Item)arrayList.get(j);
                    if (item2.getRows() != n3) {
                        throw new RuntimeException("Row miss-matched. " + n3 + " " + item2.getRows());
                    }
                    n4 += item2.getColumns();
                }
                n += n3;
                if (n2 == 0) {
                    n2 = n4;
                } else if (n2 != n4) {
                    throw new RuntimeException("Unexpected number of columns");
                }
                arrayList.clear();
                continue;
            }
            arrayList.add(item);
        }
        denseMatrix64F.reshape(n, n2);
    }

    private static class Item {
        Variable variable;
        boolean endRow;
        boolean matrix;

        private Item(Variable variable) {
            this.variable = variable;
            this.matrix = variable instanceof VariableMatrix;
        }

        private Item() {
            this.endRow = true;
        }

        public int getRows() {
            if (this.matrix) {
                return ((VariableMatrix)this.variable).matrix.numRows;
            }
            return 1;
        }

        public int getColumns() {
            if (this.matrix) {
                return ((VariableMatrix)this.variable).matrix.numCols;
            }
            return 1;
        }

        public DenseMatrix64F getMatrix() {
            return ((VariableMatrix)this.variable).matrix;
        }

        public double getValue() {
            return ((VariableScalar)this.variable).getDouble();
        }
    }
}

