/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.data;

import java.io.Serializable;
import org.ejml.data.Matrix;
import org.ejml.data.RealMatrix64F;
import org.ejml.data.ReshapeMatrix;

public class DenseD2Matrix64F
implements Serializable,
ReshapeMatrix,
RealMatrix64F {
    public double[][] data;
    public int numRows;
    public int numCols;

    public DenseD2Matrix64F(int n, int n2) {
        this.data = new double[n][n2];
        this.numRows = n;
        this.numCols = n2;
    }

    @Override
    public void reshape(int n, int n2) {
        if (n > this.data.length) {
            throw new IllegalArgumentException("Requested number of rows is too great.");
        }
        this.numRows = n;
        if (n2 > this.data[0].length) {
            throw new IllegalArgumentException("Requested number of columns is too great.");
        }
        this.numCols = n2;
    }

    @Override
    public double get(int n, int n2) {
        return this.data[n][n2];
    }

    @Override
    public void set(int n, int n2, double d) {
        this.data[n][n2] = d;
    }

    @Override
    public double unsafe_get(int n, int n2) {
        return this.get(n, n2);
    }

    @Override
    public void unsafe_set(int n, int n2, double d) {
        this.set(n, n2, d);
    }

    @Override
    public int getNumElements() {
        return this.numRows * this.numCols;
    }

    @Override
    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public int getNumCols() {
        return this.numCols;
    }

    @Override
    public void print() {
    }

    @Override
    public <T extends Matrix> T copy() {
        return null;
    }

    @Override
    public void set(Matrix matrix) {
        throw new RuntimeException("Not yet supported");
    }
}

