/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.mult;

import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class MatrixMultQuad {
    public static void multQuad1(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, DenseMatrix64F denseMatrix64F3) {
        if (denseMatrix64F.numCols != denseMatrix64F2.numCols || denseMatrix64F.numCols != denseMatrix64F2.numRows || denseMatrix64F.numRows != denseMatrix64F3.numRows || denseMatrix64F.numRows != denseMatrix64F3.numCols) {
            throw new IllegalArgumentException("Incompatible matrix shapes");
        }
        CommonOps.fill(denseMatrix64F3, 0.0);
        for (int i = 0; i < denseMatrix64F.numRows; ++i) {
            for (int j = 0; j < denseMatrix64F.numCols; ++j) {
                double d = 0.0;
                int n = i * denseMatrix64F.numCols;
                int n2 = j;
                int n3 = n + denseMatrix64F.numCols;
                while (n < n3) {
                    d += denseMatrix64F.data[n] * denseMatrix64F2.data[n2];
                    ++n;
                    n2 += denseMatrix64F2.numCols;
                }
                int n4 = i * denseMatrix64F3.numCols;
                n = j;
                n3 = n4 + denseMatrix64F.numRows;
                while (n4 < n3) {
                    int n5 = n4++;
                    denseMatrix64F3.data[n5] = denseMatrix64F3.data[n5] + d * denseMatrix64F.data[n];
                    n += denseMatrix64F.numCols;
                }
            }
        }
    }
}

