/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.qr;

import org.ejml.alg.dense.decomposition.TriangularSolver;
import org.ejml.alg.dense.linsol.qr.BaseLinearSolverQrp_D64;
import org.ejml.data.DenseMatrix64F;
import org.ejml.interfaces.decomposition.QRPDecomposition;
import org.ejml.ops.CommonOps;

public class SolvePseudoInverseQrp_D64
extends BaseLinearSolverQrp_D64 {
    private DenseMatrix64F Q = new DenseMatrix64F(1, 1);
    private DenseMatrix64F x_basic = new DenseMatrix64F(1, 1);

    public SolvePseudoInverseQrp_D64(QRPDecomposition<DenseMatrix64F> qRPDecomposition, boolean bl) {
        super(qRPDecomposition, bl);
    }

    @Override
    public boolean setA(DenseMatrix64F denseMatrix64F) {
        if (!super.setA(denseMatrix64F)) {
            return false;
        }
        this.Q.reshape(denseMatrix64F.numRows, denseMatrix64F.numRows);
        this.decomposition.getQ(this.Q, false);
        return true;
    }

    @Override
    public void solve(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        if (denseMatrix64F2.numRows != this.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for X");
        }
        if (denseMatrix64F.numRows != this.numRows || denseMatrix64F.numCols != denseMatrix64F2.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for B");
        }
        int n = denseMatrix64F.numCols;
        int[] nArray = this.decomposition.getPivots();
        for (int i = 0; i < n; ++i) {
            int n2;
            this.x_basic.reshape(this.numRows, 1);
            this.Y.reshape(this.numRows, 1);
            for (n2 = 0; n2 < this.numRows; ++n2) {
                this.Y.data[n2] = denseMatrix64F.get(n2, i);
            }
            CommonOps.multTransA(this.Q, this.Y, this.x_basic);
            TriangularSolver.solveU(this.R11.data, this.x_basic.data, this.rank);
            this.x_basic.reshape(this.numCols, 1, true);
            for (n2 = this.rank; n2 < this.numCols; ++n2) {
                this.x_basic.data[n2] = 0.0;
            }
            if (this.norm2Solution && this.rank < this.numCols) {
                this.upgradeSolution(this.x_basic);
            }
            for (n2 = 0; n2 < this.numCols; ++n2) {
                denseMatrix64F2.set(nArray[n2], i, this.x_basic.data[n2]);
            }
        }
    }

    @Override
    public boolean modifiesA() {
        return this.decomposition.inputModified();
    }

    @Override
    public boolean modifiesB() {
        return false;
    }
}

