/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.bidiagonal;

import org.ejml.alg.dense.decomposition.bidiagonal.BidiagonalDecompositionRow_D64;
import org.ejml.data.DenseMatrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.BidiagonalDecomposition;
import org.ejml.interfaces.decomposition.QRPDecomposition;
import org.ejml.ops.CommonOps;

public class BidiagonalDecompositionTall_D64
implements BidiagonalDecomposition<DenseMatrix64F> {
    QRPDecomposition<DenseMatrix64F> decompQRP = DecompositionFactory.qrp(500, 100);
    BidiagonalDecomposition<DenseMatrix64F> decompBi = new BidiagonalDecompositionRow_D64();
    DenseMatrix64F B = new DenseMatrix64F(1, 1);
    int m;
    int n;
    int min;

    @Override
    public void getDiagonal(double[] dArray, double[] dArray2) {
        dArray[0] = this.B.get(0);
        for (int i = 1; i < this.n; ++i) {
            dArray[i] = this.B.unsafe_get(i, i);
            dArray2[i - 1] = this.B.unsafe_get(i - 1, i);
        }
    }

    @Override
    public DenseMatrix64F getB(DenseMatrix64F denseMatrix64F, boolean bl) {
        denseMatrix64F = BidiagonalDecompositionRow_D64.handleB(denseMatrix64F, bl, this.m, this.n, this.min);
        denseMatrix64F.set(0, 0, this.B.get(0, 0));
        for (int i = 1; i < this.min; ++i) {
            denseMatrix64F.set(i, i, this.B.get(i, i));
            denseMatrix64F.set(i - 1, i, this.B.get(i - 1, i));
        }
        if (this.n > this.m) {
            denseMatrix64F.set(this.min - 1, this.min, this.B.get(this.min - 1, this.min));
        }
        return denseMatrix64F;
    }

    @Override
    public DenseMatrix64F getU(DenseMatrix64F denseMatrix64F, boolean bl, boolean bl2) {
        denseMatrix64F = BidiagonalDecompositionRow_D64.handleU(denseMatrix64F, false, bl2, this.m, this.n, this.min);
        if (bl2) {
            DenseMatrix64F denseMatrix64F2 = this.decompQRP.getQ(null, true);
            DenseMatrix64F denseMatrix64F3 = this.decompBi.getU(null, false, true);
            CommonOps.mult(denseMatrix64F2, denseMatrix64F3, denseMatrix64F);
        } else {
            DenseMatrix64F denseMatrix64F4 = this.decompQRP.getQ(denseMatrix64F, false);
            DenseMatrix64F denseMatrix64F5 = this.decompBi.getU(null, false, true);
            DenseMatrix64F denseMatrix64F6 = CommonOps.extract(denseMatrix64F4, 0, denseMatrix64F4.numRows, 0, this.min);
            DenseMatrix64F denseMatrix64F7 = new DenseMatrix64F(denseMatrix64F6.numRows, denseMatrix64F5.numCols);
            CommonOps.mult(denseMatrix64F6, denseMatrix64F5, denseMatrix64F7);
            CommonOps.insert(denseMatrix64F7, denseMatrix64F4, 0, 0);
        }
        if (bl) {
            CommonOps.transpose(denseMatrix64F);
        }
        return denseMatrix64F;
    }

    @Override
    public DenseMatrix64F getV(DenseMatrix64F denseMatrix64F, boolean bl, boolean bl2) {
        return this.decompBi.getV(denseMatrix64F, bl, bl2);
    }

    @Override
    public boolean decompose(DenseMatrix64F denseMatrix64F) {
        if (!this.decompQRP.decompose(denseMatrix64F)) {
            return false;
        }
        this.m = denseMatrix64F.numRows;
        this.n = denseMatrix64F.numCols;
        this.min = Math.min(this.m, this.n);
        this.B.reshape(this.min, this.n, false);
        this.decompQRP.getR(this.B, true);
        DenseMatrix64F denseMatrix64F2 = new DenseMatrix64F(this.min, this.n);
        DenseMatrix64F denseMatrix64F3 = this.decompQRP.getPivotMatrix(null);
        CommonOps.multTransB(this.B, denseMatrix64F3, denseMatrix64F2);
        this.B.set(denseMatrix64F2);
        return this.decompBi.decompose(this.B);
    }

    @Override
    public boolean inputModified() {
        return this.decompQRP.inputModified();
    }
}

