/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decompose.chol;

import org.ejml.data.CDenseMatrix64F;
import org.ejml.data.Complex64F;
import org.ejml.interfaces.decomposition.CholeskyDecomposition;
import org.ejml.ops.CCommonOps;

public abstract class CholeskyDecompositionCommon_CD64
implements CholeskyDecomposition<CDenseMatrix64F> {
    protected int n;
    protected CDenseMatrix64F T;
    protected double[] t;
    protected boolean lower;
    protected Complex64F det = new Complex64F();

    public CholeskyDecompositionCommon_CD64(boolean bl) {
        this.lower = bl;
    }

    @Override
    public boolean isLower() {
        return this.lower;
    }

    @Override
    public boolean decompose(CDenseMatrix64F cDenseMatrix64F) {
        if (cDenseMatrix64F.numRows != cDenseMatrix64F.numCols) {
            throw new IllegalArgumentException("Must be a square matrix.");
        }
        this.n = cDenseMatrix64F.numRows;
        this.T = cDenseMatrix64F;
        this.t = this.T.data;
        if (this.lower) {
            return this.decomposeLower();
        }
        return this.decomposeUpper();
    }

    @Override
    public boolean inputModified() {
        return true;
    }

    protected abstract boolean decomposeLower();

    protected abstract boolean decomposeUpper();

    @Override
    public CDenseMatrix64F getT(CDenseMatrix64F cDenseMatrix64F) {
        if (cDenseMatrix64F == null) {
            cDenseMatrix64F = new CDenseMatrix64F(this.n, this.n);
        } else {
            if (cDenseMatrix64F.numRows != this.n || cDenseMatrix64F.numCols != this.n) {
                throw new IllegalArgumentException("Unexpected matrix dimension for T.");
            }
            CCommonOps.fill(cDenseMatrix64F, 0.0, 0.0);
        }
        if (this.lower) {
            for (int i = 0; i < this.n; ++i) {
                int n = i * this.n * 2;
                for (int j = 0; j <= i; ++j) {
                    cDenseMatrix64F.data[n] = this.T.data[n];
                    cDenseMatrix64F.data[++n] = this.T.data[n];
                    ++n;
                }
            }
        } else {
            for (int i = 0; i < this.n; ++i) {
                int n = (i * this.n + i) * 2;
                for (int j = i; j < this.n; ++j) {
                    cDenseMatrix64F.data[n] = this.T.data[n];
                    cDenseMatrix64F.data[++n] = this.T.data[n];
                    ++n;
                }
            }
        }
        return cDenseMatrix64F;
    }

    public CDenseMatrix64F _getT() {
        return this.T;
    }

    @Override
    public Complex64F computeDeterminant() {
        double d = 1.0;
        int n = this.n * this.n * 2;
        for (int i = 0; i < n; i += 2 * (this.n + 1)) {
            d *= this.t[i];
        }
        this.det.real = d * d;
        this.det.imaginary = 0.0;
        return this.det;
    }
}

