/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.block.linsol.chol;

import org.ejml.alg.block.BlockMatrixOps;
import org.ejml.alg.block.BlockTriangularSolver;
import org.ejml.alg.block.decomposition.chol.CholeskyOuterForm_B64;
import org.ejml.data.BlockMatrix64F;
import org.ejml.data.D1Submatrix64F;
import org.ejml.interfaces.decomposition.CholeskyDecomposition;
import org.ejml.interfaces.linsol.LinearSolver;
import org.ejml.ops.SpecializedOps;

public class BlockCholeskyOuterSolver
implements LinearSolver<BlockMatrix64F> {
    private CholeskyOuterForm_B64 decomposer = new CholeskyOuterForm_B64(true);
    private int blockLength;
    private double[] temp;

    @Override
    public boolean setA(BlockMatrix64F blockMatrix64F) {
        if (!this.decomposer.decompose(blockMatrix64F)) {
            return false;
        }
        this.blockLength = blockMatrix64F.blockLength;
        return true;
    }

    @Override
    public double quality() {
        return SpecializedOps.qualityTriangular(this.decomposer.getT((BlockMatrix64F)null));
    }

    @Override
    public void solve(BlockMatrix64F blockMatrix64F, BlockMatrix64F blockMatrix64F2) {
        if (blockMatrix64F.blockLength != this.blockLength) {
            throw new IllegalArgumentException("Unexpected blocklength in B.");
        }
        D1Submatrix64F d1Submatrix64F = new D1Submatrix64F(this.decomposer.getT((BlockMatrix64F)null));
        if (blockMatrix64F2 != null) {
            if (blockMatrix64F2.blockLength != this.blockLength) {
                throw new IllegalArgumentException("Unexpected blocklength in X.");
            }
            if (blockMatrix64F2.numRows != d1Submatrix64F.col1) {
                throw new IllegalArgumentException("Not enough rows in X");
            }
        }
        if (blockMatrix64F.numRows != d1Submatrix64F.col1) {
            throw new IllegalArgumentException("Not enough rows in B");
        }
        BlockTriangularSolver.solve(this.blockLength, false, d1Submatrix64F, new D1Submatrix64F(blockMatrix64F), false);
        BlockTriangularSolver.solve(this.blockLength, false, d1Submatrix64F, new D1Submatrix64F(blockMatrix64F), true);
        if (blockMatrix64F2 != null) {
            BlockMatrixOps.extractAligned(blockMatrix64F, blockMatrix64F2);
        }
    }

    @Override
    public void invert(BlockMatrix64F blockMatrix64F) {
        BlockMatrix64F blockMatrix64F2 = this.decomposer.getT((BlockMatrix64F)null);
        if (blockMatrix64F.numRows != blockMatrix64F2.numRows || blockMatrix64F.numCols != blockMatrix64F2.numCols) {
            throw new IllegalArgumentException("Unexpected number or rows and/or columns");
        }
        if (this.temp == null || this.temp.length < this.blockLength * this.blockLength) {
            this.temp = new double[this.blockLength * this.blockLength];
        }
        BlockMatrixOps.zeroTriangle(true, blockMatrix64F);
        D1Submatrix64F d1Submatrix64F = new D1Submatrix64F(blockMatrix64F2);
        D1Submatrix64F d1Submatrix64F2 = new D1Submatrix64F(blockMatrix64F);
        BlockTriangularSolver.invert(this.blockLength, false, d1Submatrix64F, d1Submatrix64F2, this.temp);
        BlockTriangularSolver.solveL(this.blockLength, d1Submatrix64F, d1Submatrix64F2, true);
    }

    @Override
    public boolean modifiesA() {
        return this.decomposer.inputModified();
    }

    @Override
    public boolean modifiesB() {
        return true;
    }

    @Override
    public CholeskyDecomposition<BlockMatrix64F> getDecomposition() {
        return this.decomposer;
    }
}

