/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jplasma.tdouble;

import edu.emory.mathcs.jplasma.Barrier;
import edu.emory.mathcs.jplasma.tdouble.Dallocate;
import edu.emory.mathcs.jplasma.tdouble.Dauxiliary;
import edu.emory.mathcs.jplasma.tdouble.DbdlConvert;
import edu.emory.mathcs.jplasma.tdouble.Dcommon;
import edu.emory.mathcs.jplasma.tdouble.Pdgetrf;
import java.util.concurrent.locks.Lock;

class Dgetrf {
    private Dgetrf() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int plasma_DGETRF(int M, int N, double[] A, int A_offset, int LDA, double[] L, int L_offset, int[] IPIV, int IPIV_offset) {
        int i;
        double[] bdl_mem;
        int NT;
        if (!Dcommon.plasma_cntrl.initialized) {
            Dauxiliary.plasma_warning("plasma_DGETRF", "PLASMA not initialized");
            return -1;
        }
        if (M < 0) {
            Dauxiliary.plasma_error("plasma_DGETRF", "illegal value of M");
            return -4;
        }
        if (N < 0) {
            Dauxiliary.plasma_error("plasma_DGETRF", "illegal value of N");
            return -4;
        }
        if (LDA < Math.max(1, M)) {
            Dauxiliary.plasma_error("plasma_DGETRF", "illegal value of LDA");
            return -4;
        }
        if (Math.min(M, N) == 0) {
            return 0;
        }
        int status = Dauxiliary.plasma_tune(3, M, N, 0);
        if (status != 0) {
            Dauxiliary.plasma_error("plasma_DGETRF", "plasma_tune() failed");
            return status;
        }
        int NB = Dcommon.plasma_cntrl.NB;
        int MT = M % NB == 0 ? M / NB : M / NB + 1;
        int size_elems = MT * (NT = N % NB == 0 ? N / NB : N / NB + 1);
        if (Dcommon.plasma_cntrl.progress_size_elems < size_elems) {
            status = Dallocate.plasma_free_aux_progress();
            if (status != 0) {
                Dauxiliary.plasma_error("plasma_DGETRF", "plasma_free_aux_progress() failed");
            }
            if ((status = Dallocate.plasma_alloc_aux_progress(size_elems)) != 0) {
                Dauxiliary.plasma_error("plasma_DGETRF", "plasma_alloc_aux_progress() failed");
                return status;
            }
        }
        double[] Abdl = bdl_mem = Dcommon.plasma_aux.bdl_mem;
        int Abdl_offset = 0;
        double[] Lbdl = bdl_mem;
        int Lbdl_offset = MT * NT * Dcommon.plasma_cntrl.NBNBSIZE;
        size_elems = Lbdl_offset + MT * NT * Dcommon.plasma_cntrl.IBNBSIZE;
        if (Dcommon.plasma_cntrl.bdl_size_elems < size_elems) {
            status = Dallocate.plasma_free_aux_bdl();
            if (status != 0) {
                Dauxiliary.plasma_error("plasma_DGETRF", "plasma_free_aux_bdl() failed");
                return status;
            }
            status = Dallocate.plasma_alloc_aux_bdl(size_elems);
            if (status != 0) {
                Dauxiliary.plasma_error("plasma_DGETRF", "plasma_alloc_aux_bdl() failed");
                return status;
            }
            Abdl = bdl_mem = Dcommon.plasma_aux.bdl_mem;
            Abdl_offset = 0;
            Lbdl = bdl_mem;
            Lbdl_offset = MT * NT * Dcommon.plasma_cntrl.NBNBSIZE;
        }
        Dcommon.plasma_args.F77 = A;
        Dcommon.plasma_args.F77_offset = A_offset;
        Dcommon.plasma_args.A = Abdl;
        Dcommon.plasma_args.A_offset = Abdl_offset;
        Dcommon.plasma_args.M = M;
        Dcommon.plasma_args.N = N;
        Dcommon.plasma_args.LDA = LDA;
        Dcommon.plasma_args.NB = Dcommon.plasma_cntrl.NB;
        Dcommon.plasma_args.MT = MT;
        Dcommon.plasma_args.NT = NT;
        Dcommon.plasma_args.NBNBSIZE = Dcommon.plasma_cntrl.NBNBSIZE;
        Lock lock = Dcommon.plasma_cntrl.action_mutex;
        lock.lock();
        try {
            Dcommon.plasma_cntrl.action = 9;
            Dcommon.plasma_cntrl.action_condt.signalAll();
        }
        finally {
            lock.unlock();
        }
        Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
        Dcommon.plasma_cntrl.action = 0;
        DbdlConvert.plasma_lapack_to_bdl(Dcommon.plasma_args.F77, Dcommon.plasma_args.F77_offset, Dcommon.plasma_args.A, Dcommon.plasma_args.A_offset, Dcommon.plasma_args.M, Dcommon.plasma_args.N, Dcommon.plasma_args.LDA, Dcommon.plasma_args.NB, Dcommon.plasma_args.MT, Dcommon.plasma_args.NT, Dcommon.plasma_args.NBNBSIZE, Dcommon.plasma_cntrl.cores_num, 0);
        Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
        size_elems = IPIV_offset + NT * NT * Dcommon.plasma_cntrl.NB;
        for (i = IPIV_offset; i < size_elems; ++i) {
            IPIV[i] = 0;
        }
        size_elems = Lbdl_offset + NT * NT * Dcommon.plasma_cntrl.IBNBSIZE;
        for (i = Lbdl_offset; i < size_elems; ++i) {
            Lbdl[i] = 0.0;
        }
        Dcommon.plasma_args.M = M;
        Dcommon.plasma_args.N = N;
        Dcommon.plasma_args.A = Abdl;
        Dcommon.plasma_args.A_offset = Abdl_offset;
        Dcommon.plasma_args.NB = Dcommon.plasma_cntrl.NB;
        Dcommon.plasma_args.NBNBSIZE = Dcommon.plasma_cntrl.NBNBSIZE;
        Dcommon.plasma_args.IBNBSIZE = Dcommon.plasma_cntrl.IBNBSIZE;
        Dcommon.plasma_args.IB = Dcommon.plasma_cntrl.IB;
        Dcommon.plasma_args.MT = MT;
        Dcommon.plasma_args.NT = NT;
        Dcommon.plasma_args.L = Lbdl;
        Dcommon.plasma_args.L_offset = Lbdl_offset;
        Dcommon.plasma_args.IPIV = IPIV;
        Dcommon.plasma_args.IPIV_offset = IPIV_offset;
        Dauxiliary.plasma_clear_aux_progress(MT * NT, -1);
        lock = Dcommon.plasma_cntrl.action_mutex;
        lock.lock();
        try {
            Dcommon.plasma_cntrl.action = 7;
            Dcommon.plasma_cntrl.action_condt.signalAll();
        }
        finally {
            lock.unlock();
        }
        Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
        Dcommon.plasma_cntrl.action = 0;
        Pdgetrf.plasma_pDGETRF(Dcommon.plasma_args.M, Dcommon.plasma_args.N, Dcommon.plasma_args.A, Dcommon.plasma_args.A_offset, Dcommon.plasma_args.NB, Dcommon.plasma_args.NBNBSIZE, Dcommon.plasma_args.IBNBSIZE, Dcommon.plasma_args.IB, Dcommon.plasma_args.MT, Dcommon.plasma_args.NT, Dcommon.plasma_args.L, Dcommon.plasma_args.L_offset, Dcommon.plasma_args.IPIV, Dcommon.plasma_args.IPIV_offset, Dcommon.plasma_args.INFO, Dcommon.plasma_cntrl.cores_num, 0);
        Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
        System.arraycopy(Lbdl, Lbdl_offset, L, L_offset, MT * NT * Dcommon.plasma_cntrl.IBNBSIZE);
        Dcommon.plasma_args.A = Abdl;
        Dcommon.plasma_args.A_offset = Abdl_offset;
        Dcommon.plasma_args.F77 = A;
        Dcommon.plasma_args.F77_offset = A_offset;
        Dcommon.plasma_args.M = M;
        Dcommon.plasma_args.N = N;
        Dcommon.plasma_args.LDA = LDA;
        Dcommon.plasma_args.NB = Dcommon.plasma_cntrl.NB;
        Dcommon.plasma_args.MT = MT;
        Dcommon.plasma_args.NT = NT;
        Dcommon.plasma_args.NBNBSIZE = Dcommon.plasma_cntrl.NBNBSIZE;
        lock = Dcommon.plasma_cntrl.action_mutex;
        lock.lock();
        try {
            Dcommon.plasma_cntrl.action = 10;
            Dcommon.plasma_cntrl.action_condt.signalAll();
        }
        finally {
            lock.unlock();
        }
        Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
        Dcommon.plasma_cntrl.action = 0;
        DbdlConvert.plasma_bdl_to_lapack(Dcommon.plasma_args.A, Dcommon.plasma_args.A_offset, Dcommon.plasma_args.F77, Dcommon.plasma_args.F77_offset, Dcommon.plasma_args.M, Dcommon.plasma_args.N, Dcommon.plasma_args.LDA, Dcommon.plasma_args.NB, Dcommon.plasma_args.MT, Dcommon.plasma_args.NT, Dcommon.plasma_args.NBNBSIZE, Dcommon.plasma_cntrl.cores_num, 0);
        Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
        return Dcommon.plasma_args.INFO.val;
    }
}

