/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.storage.inmemory;

import com.datumbox.framework.common.storage.abstracts.AbstractFileStorageEngine;
import com.datumbox.framework.common.storage.interfaces.StorageEngine;
import com.datumbox.framework.storage.inmemory.DeepCopy;
import com.datumbox.framework.storage.inmemory.InMemoryConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class InMemoryEngine
extends AbstractFileStorageEngine<InMemoryConfiguration> {
    private Map<String, WeakReference<?>> catalog = new HashMap();

    protected InMemoryEngine(String storageName, InMemoryConfiguration storageConfiguration) {
        super(storageName, storageConfiguration);
    }

    @Override
    public boolean rename(String newStorageName) {
        this.assertConnectionOpen();
        if (this.storageName.equals(newStorageName)) {
            return false;
        }
        this.catalog.clear();
        try {
            this.moveDirectory(this.getRootPath(this.storageName), this.getRootPath(newStorageName));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        this.logger.trace("Renamed storage {} to {}", (Object)this.storageName, (Object)newStorageName);
        this.storageName = newStorageName;
        return true;
    }

    @Override
    public boolean existsObject(String name) {
        this.assertConnectionOpen();
        if (this.catalog.containsKey(name)) {
            return true;
        }
        return new File(this.getRootPath(this.storageName).toFile(), name).exists();
    }

    @Override
    public <T extends Serializable> void saveObject(String name, T serializableObject) {
        this.assertConnectionOpen();
        try {
            Path rootPath = this.getRootPath(this.storageName);
            this.createDirectoryIfNotExists(rootPath);
            Path objectPath = new File(rootPath.toFile(), name).toPath();
            Files.write(objectPath, DeepCopy.serialize(serializableObject), new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        this.catalog.put(name, new WeakReference<T>(serializableObject));
    }

    @Override
    public <T extends Serializable> T loadObject(String name, Class<T> klass) throws NoSuchElementException {
        Serializable obj;
        this.assertConnectionOpen();
        if (!this.existsObject(name)) {
            throw new NoSuchElementException("Can't find any object with name '" + name + "'");
        }
        try {
            Path objectPath = new File(this.getRootPath(this.storageName).toFile(), name).toPath();
            Object serializableObject = DeepCopy.deserialize(Files.readAllBytes(objectPath));
            obj = (Serializable)klass.cast(serializableObject);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        this.catalog.put(name, new WeakReference<Serializable>(obj));
        return (T)obj;
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        super.close();
        this.catalog = null;
        this.logger.trace("Closed storage {}", (Object)this.storageName);
    }

    @Override
    public void clear() {
        this.assertConnectionOpen();
        this.catalog.clear();
        try {
            this.deleteDirectory(this.getRootPath(this.storageName), true);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public <K, V> Map<K, V> getBigMap(String name, Class<K> keyClass, Class<V> valueClass, StorageEngine.MapType type, StorageEngine.StorageHint storageHint, boolean isConcurrent, boolean isTemporary) {
        AbstractMap m;
        this.assertConnectionOpen();
        if (StorageEngine.MapType.HASHMAP.equals((Object)type)) {
            m = isConcurrent ? new ConcurrentHashMap() : new HashMap();
        } else if (StorageEngine.MapType.TREEMAP.equals((Object)type)) {
            m = isConcurrent ? new ConcurrentSkipListMap() : new TreeMap();
        } else {
            throw new IllegalArgumentException("Unsupported MapType.");
        }
        this.catalog.put(name, new WeakReference(m));
        return m;
    }

    @Override
    public <T extends Map> void dropBigMap(String name, T map) {
        this.assertConnectionOpen();
        map.clear();
        this.catalog.remove(name);
    }

    @Override
    protected Set<Class> nonSerializableBigMaps() {
        return Collections.emptySet();
    }
}

