/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.timeseries;

import com.datumbox.framework.common.dataobjects.FlatDataList;

public class Smoothing {
    public static double simpleMovingAverage(FlatDataList flatDataList, int N) {
        double SMA = 0.0;
        int counter = 0;
        for (int i = flatDataList.size() - 1; i >= 0; --i) {
            double Yti = flatDataList.getDouble(i);
            if (counter >= N) break;
            SMA += Yti;
            ++counter;
        }
        return SMA /= (double)counter;
    }

    public static double simpleMovingAverageQuick(double Yt, double YtminusN, double Ft, int N) {
        double SMA = (Yt - YtminusN) / (double)N + Ft;
        return SMA;
    }

    public static double weightedMovingAverage(FlatDataList flatDataList, int N) {
        double WMA = 0.0;
        double denominator = 0.0;
        int counter = 0;
        for (int i = flatDataList.size() - 1; i >= 0; --i) {
            double Yti = flatDataList.getDouble(i);
            if (counter >= N) break;
            double weight = N - counter;
            WMA += weight * Yti;
            denominator += weight;
            ++counter;
        }
        return WMA /= denominator;
    }

    public static double simpleExponentialSmoothing(FlatDataList flatDataList, double a) {
        double EMA = 0.0;
        int count = 0;
        for (int i = flatDataList.size() - 1; i >= 0; --i) {
            double Yti = flatDataList.getDouble(i);
            EMA += a * Math.pow(1.0 - a, count) * Yti;
            ++count;
        }
        return EMA;
    }

    public static double simpleExponentialSmoothingQuick(double Ytminus1, double Stminus1, double a) {
        double EMA = a * Ytminus1 + (1.0 - a) * Stminus1;
        return EMA;
    }

    public static double holtWintersSmoothing(FlatDataList flatDataList, int season_length, double alpha, double beta, double gamma, double dev_gamma) {
        int i;
        int n = flatDataList.size();
        double trend1 = 0.0;
        for (int i2 = 0; i2 < season_length; ++i2) {
            trend1 += flatDataList.getDouble(i2).doubleValue();
        }
        trend1 /= (double)season_length;
        double trend2 = 0.0;
        for (int i3 = season_length; i3 < 2 * season_length; ++i3) {
            trend2 += flatDataList.getDouble(i3).doubleValue();
        }
        double initial_trend = ((trend2 /= (double)season_length) - trend1) / (double)season_length;
        double initial_level = flatDataList.getDouble(0);
        double[] index = new double[n];
        for (int i4 = 0; i4 < n; ++i4) {
            double val = flatDataList.getDouble(i4);
            index[i4] = val / (initial_level + ((double)i4 + 1.0) * initial_trend);
        }
        double[] season = new double[n + season_length];
        double sum = 0.0;
        for (int i5 = 0; i5 < season_length; ++i5) {
            season[i5] = (index[i5] + index[i5 + season_length]) / 2.0;
            sum += season[i5];
        }
        double season_factor = (double)season_length / sum;
        int i6 = 0;
        while (i6 < season_length) {
            int n2 = i6++;
            season[n2] = season[n2] * season_factor;
        }
        double alpha_level = initial_level;
        double beta_trend = initial_trend;
        for (i = 0; i < n; ++i) {
            double value = flatDataList.getDouble(i);
            double temp_level = alpha_level;
            double temp_trend = beta_trend;
            alpha_level = alpha * value / season[i] + (1.0 - alpha) * (temp_level + temp_trend);
            beta_trend = beta * (alpha_level - temp_level) + (1.0 - beta) * temp_trend;
            season[i + season_length] = gamma * value / alpha_level + (1.0 - gamma) * season[i];
        }
        double holtWinterTplus1 = alpha_level + beta_trend * season[i + 1];
        return holtWinterTplus1;
    }
}

