/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.sampling;

import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.AssociativeArray2D;
import com.datumbox.framework.common.dataobjects.FlatDataCollection;
import com.datumbox.framework.common.dataobjects.FlatDataList;
import com.datumbox.framework.common.dataobjects.TransposeDataCollection;
import com.datumbox.framework.common.dataobjects.TransposeDataList;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.core.statistics.descriptivestatistics.Descriptives;
import com.datumbox.framework.core.statistics.sampling.SimpleRandomSampling;
import java.util.Map;

public class StratifiedSampling {
    public static TransposeDataCollection weightedProbabilitySampling(AssociativeArray2D strataFrequencyTable, AssociativeArray nh, boolean withReplacement) {
        TransposeDataCollection sampledIds = new TransposeDataCollection();
        for (Map.Entry<Object, AssociativeArray> entry : strataFrequencyTable.entrySet()) {
            Object strata = entry.getKey();
            Number sampleN = (Number)nh.get(strata);
            if (sampleN == null) continue;
            sampledIds.put(strata, SimpleRandomSampling.weightedSampling(entry.getValue(), sampleN.intValue(), withReplacement));
        }
        return sampledIds;
    }

    public static TransposeDataCollection randomSampling(TransposeDataList strataIdList, AssociativeArray nh, boolean withReplacement) {
        TransposeDataCollection sampledIds = new TransposeDataCollection();
        for (Map.Entry<Object, FlatDataList> entry : strataIdList.entrySet()) {
            Object strata = entry.getKey();
            Number sampleN = (Number)nh.get(strata);
            if (sampleN == null) continue;
            sampledIds.put(strata, SimpleRandomSampling.randomSampling(entry.getValue(), sampleN.intValue(), withReplacement));
        }
        return sampledIds;
    }

    public static double mean(TransposeDataCollection sampleDataCollection, AssociativeArray populationNh) {
        double populationN = Descriptives.sum(populationNh.toFlatDataCollection());
        if (populationN <= 0.0) {
            throw new IllegalArgumentException("The populationN parameter must be positive.");
        }
        double mean = 0.0;
        for (Map.Entry<Object, FlatDataCollection> entry : sampleDataCollection.entrySet()) {
            Object strata = entry.getKey();
            Integer strataPopulation = ((Number)populationNh.get(strata)).intValue();
            if (strataPopulation == null) {
                throw new IllegalArgumentException("Invalid strata population size.");
            }
            mean += (double)strataPopulation.intValue() * SimpleRandomSampling.mean(entry.getValue()) / populationN;
        }
        return mean;
    }

    public static double variance(TransposeDataCollection sampleDataCollection, AssociativeArray populationNh) {
        double variance = 0.0;
        int populationN = 0;
        double mean = StratifiedSampling.mean(sampleDataCollection, populationNh);
        for (Map.Entry<Object, FlatDataCollection> entry : sampleDataCollection.entrySet()) {
            Object strata = entry.getKey();
            Integer strataPopulation = ((Number)populationNh.get(strata)).intValue();
            if (strataPopulation == null) {
                throw new IllegalArgumentException("Invalid strata population size.");
            }
            populationN += strataPopulation.intValue();
            variance += (double)(strataPopulation - 1) * SimpleRandomSampling.variance(entry.getValue());
            variance += (double)strataPopulation.intValue() * Math.pow(SimpleRandomSampling.mean(entry.getValue()) - mean, 2.0);
        }
        return variance /= (double)(populationN - 1);
    }

    public static double std(TransposeDataCollection sampleDataCollection, AssociativeArray populationNh) {
        return Math.sqrt(StratifiedSampling.variance(sampleDataCollection, populationNh));
    }

    public static double xbarVariance(TransposeDataCollection sampleDataCollection, AssociativeArray nh, AssociativeArray populationNh) {
        double populationN = Descriptives.sum(populationNh.toFlatDataCollection());
        if (populationN <= 0.0) {
            throw new IllegalArgumentException("The populationN parameter must be positive.");
        }
        double variance = 0.0;
        for (Map.Entry<Object, FlatDataCollection> entry : sampleDataCollection.entrySet()) {
            Object strata = entry.getKey();
            Integer strataPopulation = ((Number)populationNh.get(strata)).intValue();
            Integer strataSample = ((Number)nh.get(strata)).intValue();
            if (strataPopulation == null || strataSample == null) {
                throw new IllegalArgumentException("Invalid strata population or sample size.");
            }
            double Wh = (double)strataPopulation.intValue() / populationN;
            variance += Wh * Wh * SimpleRandomSampling.xbarVariance(SimpleRandomSampling.variance(entry.getValue()), strataSample, strataPopulation);
        }
        return variance;
    }

    public static double xbarStd(TransposeDataCollection sampleDataCollection, AssociativeArray nh, AssociativeArray populationNh) {
        return Math.sqrt(StratifiedSampling.xbarVariance(sampleDataCollection, nh, populationNh));
    }

    public static AssociativeArray optimumSampleSize(int n, AssociativeArray populationNh, AssociativeArray populationStdh) {
        Object strata;
        AssociativeArray nh = new AssociativeArray();
        double sumNhSh = 0.0;
        for (Map.Entry<Object, Object> entry : populationNh.entrySet()) {
            strata = entry.getKey();
            Integer populationInStrata = ((Number)entry.getValue()).intValue();
            Double populationStd = populationStdh.getDouble(strata);
            if (populationStd == null || (double)populationInStrata.intValue() <= 0.0) {
                throw new IllegalArgumentException("Invalid strata population or strata std.");
            }
            double NhSh = (double)populationInStrata.intValue() * populationStd;
            sumNhSh += NhSh;
            nh.put(strata, (double)n * NhSh);
        }
        if (sumNhSh <= 0.0) {
            throw new IllegalArgumentException("Invalid strata populations.");
        }
        for (Map.Entry<Object, Object> entry : nh.entrySet()) {
            strata = entry.getKey();
            nh.put(strata, TypeInference.toDouble(entry.getValue()) / sumNhSh);
        }
        return nh;
    }
}

