/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.sampling;

import com.datumbox.framework.common.dataobjects.FlatDataCollection;
import com.datumbox.framework.common.dataobjects.FlatDataList;
import com.datumbox.framework.common.dataobjects.TransposeDataCollection;
import com.datumbox.framework.common.dataobjects.TransposeDataList;
import com.datumbox.framework.core.common.utilities.PHPMethods;
import com.datumbox.framework.core.statistics.descriptivestatistics.Descriptives;
import java.util.Iterator;
import java.util.Map;

public class ClusterSampling {
    public static double nBar(TransposeDataList clusterIdList) {
        int populationM = clusterIdList.size();
        double nBar = 0.0;
        for (Map.Entry<Object, FlatDataList> entry : clusterIdList.entrySet()) {
            nBar += (double)entry.getValue().size() / (double)populationM;
        }
        return nBar;
    }

    public static TransposeDataCollection randomSampling(TransposeDataList clusterIdList, int sampleM) {
        TransposeDataCollection sampledIds = new TransposeDataCollection();
        Object[] selectedClusters = clusterIdList.keySet().toArray();
        PHPMethods.shuffle(selectedClusters);
        for (int i = 0; i < sampleM; ++i) {
            Object cluster = selectedClusters[i];
            sampledIds.put(cluster, clusterIdList.get(cluster).toFlatDataCollection());
        }
        return sampledIds;
    }

    public static double mean(TransposeDataCollection sampleDataCollection) {
        double mean = 0.0;
        int totalSampleN = 0;
        for (Map.Entry<Object, FlatDataCollection> entry : sampleDataCollection.entrySet()) {
            mean += Descriptives.sum(entry.getValue());
            totalSampleN += entry.getValue().size();
        }
        return mean /= (double)totalSampleN;
    }

    public static double xbarVariance(TransposeDataCollection sampleDataCollection, int populationM, double Nbar) {
        double xbarVariance = 0.0;
        int sampleM = sampleDataCollection.size();
        double mean = ClusterSampling.mean(sampleDataCollection);
        for (Map.Entry<Object, FlatDataCollection> entry : sampleDataCollection.entrySet()) {
            double sum = 0.0;
            Iterator<Double> it = entry.getValue().iteratorDouble();
            while (it.hasNext()) {
                sum += it.next() - mean;
            }
            xbarVariance += sum * sum / (double)(sampleM - 1);
        }
        return xbarVariance *= (double)(populationM - sampleM) / ((double)(populationM * sampleM) * Nbar * Nbar);
    }

    public static double xbarStd(TransposeDataCollection sampleDataCollection, int populationM, double Nbar) {
        return Math.sqrt(ClusterSampling.xbarVariance(sampleDataCollection, populationM, Nbar));
    }
}

