/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.parametrics.relatedsamples;

import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;

public class StudentsRelatedSamples {
    public static boolean testMean(double dbar, int n, double dbarStd, boolean is_twoTailed, double aLevel) {
        if (n <= 0 || dbarStd <= 0.0) {
            throw new IllegalArgumentException("All the parameters must be positive.");
        }
        double t = dbar / (dbarStd / Math.sqrt(n));
        boolean rejectH0 = StudentsRelatedSamples.checkCriticalValue(t, n, is_twoTailed, aLevel);
        return rejectH0;
    }

    private static boolean checkCriticalValue(double score, int n, boolean is_twoTailed, double aLevel) {
        double probability = ContinuousDistributions.studentsCdf(score, n - 1);
        boolean rejectH0 = false;
        double a = aLevel;
        if (is_twoTailed) {
            a = aLevel / 2.0;
        }
        if (probability <= a || probability >= 1.0 - a) {
            rejectH0 = true;
        }
        return rejectH0;
    }
}

