/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.parametrics.onesample;

import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;

public class ChisquareOneSample {
    public static boolean testVariance(double stdbar, int n, double H0std, boolean is_twoTailed, double aLevel) {
        if (n <= 1 || H0std <= 0.0) {
            throw new IllegalArgumentException("The values of the provided parameters are not within the permitted range.");
        }
        double chisquare = ((double)n - 1.0) * stdbar * stdbar / (H0std * H0std);
        boolean rejectH0 = ChisquareOneSample.checkCriticalValue(chisquare, n, is_twoTailed, aLevel);
        return rejectH0;
    }

    private static boolean checkCriticalValue(double score, int n, boolean is_twoTailed, double aLevel) {
        double probability = ContinuousDistributions.chisquareCdf(score, n - 1);
        boolean rejectH0 = false;
        double a = aLevel;
        if (is_twoTailed) {
            a = aLevel / 2.0;
        }
        if (probability <= a || probability >= 1.0 - a) {
            rejectH0 = true;
        }
        return rejectH0;
    }
}

